import os
import tarfile
from sandbox import sdk2
from sandbox.projects.rtc.resource_types import RTC_TOOL_JANITOR
from sandbox.common.types.task import ReleaseStatus
from sandbox.sandboxsdk.process import run_process


class RtcToolJanitorRun(sdk2.Task):
    def get_resource(self, resource_type, dst_path):
        res = sdk2.Resource.find(resource_type, attrs=dict(released=ReleaseStatus.STABLE)).order(-sdk2.Resource.id).first()
        res_path = str(sdk2.ResourceData(res).path)
        tarfile.open(res_path).extractall(dst_path)

    def on_execute(self):
        self.get_resource(RTC_TOOL_JANITOR, 'janitor')
        oauth_token = sdk2.Vault.data('robot-rtc-autoadmin')
        run_process(
            [
                os.path.join('janitor', 'janitor'),
                '-l', 'debug',
                'run'
            ],
            environment=dict(os.environ, OAUTH=oauth_token)
        )
