from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.common.errors import TaskFailure
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.sdk2.helpers import subprocess as sp
from sandbox.projects.common.juggler import jclient

SVN_URL = 'arcadia:/arc/trunk/arcadia/infra/rtc/golovan'


class RtcGolovanUpdater(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = ['RCCS-ADMINS']


class RtcUpdateGolovan(sdk2.Task):

    class Parameters(sdk2.Parameters):
        revision = sdk2.parameters.Integer('Revision from which to build binary or None for trunk',
                                           default=None, required=False)

    def on_execute(self):
        binary_resource = sdk2.Resource.find(
            RtcGolovanUpdater,
            attrs=dict(released='stable'),
            state=State.READY
        ).order(-sdk2.Resource.id).first()
        if binary_resource is None:
            raise TaskFailure("Binary not found!")
        binary_path = str(sdk2.ResourceData(binary_resource).path)

        arcadia_url = SVN_URL
        if self.Parameters.revision:
            arcadia_url += '@{revision}'.format(revision=self.Parameters.revision)
        arcadia_path = Arcadia.get_arcadia_src_dir(arcadia_url)
        with sdk2.helpers.ProcessLog(self, logger='updater') as pl:
            sp.Popen([binary_path], stdout=pl.stdout, stderr=sp.STDOUT, cwd=arcadia_path).wait()

        jclient.send_events_to_juggler('rtc-update-golovan', 'scheduler', 'OK', 'golovan settings keeped in sync')
