# coding: utf-8
from sandbox import sdk2


cplb_releasers = ['CPLB']


class BALANACER_GENCFG_CONFIGS_TGZ(sdk2.Resource):
    """
        Архив со сгенеренными конфигами для балансера
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = ['CPLB', 'SEARCH-RELEASERS', 'robot-testenv']
    release_subscribers = ['cplb-releases']


class BALANACER_GENCFG_CONFIGS_DIR(sdk2.Resource):
    """
        Директория со сгенеренными конфигами для балансера
    """
    auto_backup = True
    releasable = True
    executable = False
    share = False
    releasers = ['CPLB', 'SEARCH-RELEASERS', 'robot-testenv']
    release_subscribers = ['cplb-releases']


class BALANACER_GENCFG_LOGS_TGZ(sdk2.Resource):
    """
        Архив со логами интеграционных тестов конфигов балансера
    """
    auto_backup = False
    releasable = False
    executable = False
    share = False
    releasers = ['CPLB', 'robot-testenv']
    release_subscribers = ['cplb-releases']


class HAPROXY_EXECUTABLE(sdk2.Resource):
    """
        Статически собранный HAProxy с LibreSSL и PCRE
    """
    auto_backup = True
    any_arch = False
    releasable = True
    executable = True
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class NGINX_EXECUTABLE(sdk2.Resource):
    """
        Nginx с LibreSSL, PCRE, ZLIB
    """
    auto_backup = True
    any_arch = False
    releasable = True
    executable = True
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class BALANACER_ACTIVE_CHECKS_YAML(sdk2.Resource):
    """
        YAML with active checks
    """
    auto_backup = False
    executable = False
    releasable = True
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']
    share = False


class PORTO_LAYER_BALANCER_SNS(sdk2.Resource):
    """
        Porto слой для балансеров из рантайм облака для использования с общим сетевым неймспейсом.
    """
    auto_backup = True
    releasable = True
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class PORTO_LAYER_BALANCER_MTN(sdk2.Resource):
    """
        Porto слой для балансеров из рантайм облака для использования с MTN.
    """
    auto_backup = True
    releasable = True
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class OCSP_RESPONSE_FILES_TGZ(sdk2.Resource):
    """
        Архив со сгенеренными ocsp response файлами для балансера
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_BALANCER_TGZ_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия без push-client, без суб-агента Голована, конфиги из tarball
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_MTN_BALANCER_TGZ_INSTANCECTL_CONF(sdk2.Resource):
    """
        [RUNTIMECLOUD-4886] instancectl.conf for rtc-balancers in MTN w/ notify_script and cfg from tgz;
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_BALANCER_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия без push-client, без суб-агента Голована, конфиги из AWACS
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_SWAT_BALANCER_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия без push-client, без суб-агента Голована, конфиги из AWACS, секреты в instances-dir
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_BALANCER_PLUS_PUSHCLIENT_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия c push-client, без суб-агента Голована, конфиги из AWACS
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_MTN_BALANCER_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия без push-client, с суб-агентом Голована, конфиги из AWACS
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_MTN_BALANCER_PLUS_PUSHCLIENT_INSTANCECTL_CONF(sdk2.Resource):
    """
        Версия c push-client и суб-агентом Голована, конфиги из AWACS
        instancectl.conf для балансеров в RTC
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class OLD_RTC_BALANCER_ISS_HOOK_NOTIFY(sdk2.Resource):
    """
        RUNTIMECLOUD-4055. Старая версия iss_hook_notify
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class RTC_BALANCER_NON_SECRETS_TGZ(sdk2.Resource):
    """
        RUNTIMECLOUD-4055. Архив с "несекретами"
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class JUGGLER_CHECKS_BUNDLE_RTC_BALANCERS(sdk2.Resource):
    """
        RUNTIMECLOUD-4906. Бадл с пассивными проверками для балансеров
    """
    auto_backup = True
    any_arch = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class UAAS_BALANCER_INSTANCECTL_CONF(sdk2.Resource):
    """
        RUNTIMECLOUD-7313 ctl.conf for uaas.search.yandex.net balancers
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']


class GET_WORKERS_PROVIDER(sdk2.Resource):
    """
        SWAT-4452|SWAT-4543 - lua-module for define number of balancer workers
    """
    auto_backup = True
    releasable = True
    executable = False
    releasers = cplb_releasers
    release_subscribers = ['cplb-releases']
