import os

import sandbox.common.types.client as ctc
import sandbox.common.types.task as ctt

from sandbox import sdk2

from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build.parameters import get_arcadia_params
from sandbox.projects.common.nanny import nanny


class RtcSlaTentaclesAgentBinary(sdk2.Resource):
    """ Binary file - RTC SLA Tentacles agent. """
    any_arch = True
    auto_backup = False
    executable = True
    releasable = True
    ttl = 14
    arcadia_build_path = "infra/rtc_sla_tentacles/backend/bin/tentacle_agent/rtc-sla-tentacles-agent"


class RtcSlaTentaclesAgent(YaMakeTask, nanny.ReleaseToNannyTask):
    type = "RTC_SLA_TENTACLES_AGENT"
    client_tags = ctc.Tag.Group.LINUX
    input_parameters = get_arcadia_params()
    execution_space = 4 * 1024

    def get_resources(self):
        resources = {
            "description": 'RTC SLA Tentacles agent',
            "resource_path": os.path.basename(RtcSlaTentaclesAgentBinary.arcadia_build_path),
            "resource_type": RtcSlaTentaclesAgentBinary,
        }
        return {"project": resources}

    def get_targets(self):
        return [RtcSlaTentaclesAgentBinary.arcadia_build_path]

    def get_arts(self):
        return [{"path": RtcSlaTentaclesAgentBinary.arcadia_build_path}]

    def on_release(self, additional_parameters):
        additional_parameters["release_comments"] += "RTC SLA Tentacles release\n"
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        self.mark_released_resources("stable", ttl="inf")
        YaMakeTask.on_release(self, additional_parameters)

    @property
    def release_template(self):
        return self.ReleaseTemplate(
            types=[ctt.ReleaseStatus.TESTING, ctt.ReleaseStatus.STABLE])


__Task__ = RtcSlaTentaclesAgent
