import os

from sandbox import sdk2
import sandbox.common.types.task as ctt
from sandbox.projects.common.build.YaMake2 import YaMake2
import sandbox.projects.common.build.parameters as build_parameters
import sandbox.projects.common.constants as consts
from sandbox.projects.common.nanny import nanny

from sandbox.projects.rtc_sla_tentacles.resource_types import (
    RtcSlaTentaclesBackendApiBinary,
    RtcSlaTentaclesBackendWorkerBinary,
)


class RtcSlaTentaclesBackend(YaMake2, nanny.ReleaseToNannyTask2):
    """ Build RTC SLA Tentacles backend (all services). """

    class Parameters(YaMake2.Parameters):
        use_aapi_fuse = build_parameters.UseArcadiaApiFuse(default_value=True)
        use_arc_instead_of_aapi = build_parameters.UseArcInsteadOfArcadiaApi(default_value=False)
        aapi_fallback = build_parameters.AllowArcadiaApiFallback(default_value=True)
        build_system = build_parameters.BuildSystem(default_value=consts.SEMI_DISTBUILD_BUILD_SYSTEM)
        ya_make_project_params = None  # remove this params as we build specific target

        with sdk2.parameters.String('Release to Nanny') as release_to_nanny:
            release_to_nanny.values[''] = '-'
            for status in [ctt.ReleaseStatus.TESTING, ctt.ReleaseStatus.STABLE]:
                release_to_nanny.values[status] = status

    def get_resources(self):
        return {
            RtcSlaTentaclesBackendApiBinary.name: {
                "description": 'RTC SLA Tentacles Backend - Api',
                "resource_path": os.path.basename(RtcSlaTentaclesBackendApiBinary.arcadia_build_path),
                "resource_type": RtcSlaTentaclesBackendApiBinary,
            },
            RtcSlaTentaclesBackendWorkerBinary.name: {
                "description": 'RTC SLA Tentacles Backend - Worker',
                "resource_path": os.path.basename(RtcSlaTentaclesBackendWorkerBinary.arcadia_build_path),
                "resource_type": RtcSlaTentaclesBackendWorkerBinary,
            },
        }

    def get_targets(self):
        return [
            os.path.dirname(RtcSlaTentaclesBackendApiBinary.arcadia_build_path),
            os.path.dirname(RtcSlaTentaclesBackendWorkerBinary.arcadia_build_path),
        ]

    def get_arts(self):
        return [
            {"path": RtcSlaTentaclesBackendApiBinary.arcadia_build_path},
            {"path": RtcSlaTentaclesBackendWorkerBinary.arcadia_build_path},
        ]

    def on_success(self, prev_status):
        if self.Parameters.release_to_nanny:
            additional_parameters = dict(
                releaser=self.author,
                release_status=self.Parameters.release_to_nanny,
                release_subject=self.Parameters.description,
                email_notifications=dict(to=[], cc=[]),
            )
            self.on_release(additional_parameters)

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        YaMake2.on_release(self, additional_parameters)
