# coding: utf-8

from sandbox import sdk2


class RtcSlaTentaclesBackendApiBinary(sdk2.Resource):
    """ Binary file - RTC SLA Tentacles backend Api component. """
    any_arch = True
    auto_backup = False
    executable = True
    releasable = True
    ttl = 14
    arcadia_build_path = "infra/rtc_sla_tentacles/backend/bin/api/rtc-sla-tentacles-backend-api"


class RtcSlaTentaclesBackendWorkerBinary(sdk2.Resource):
    """ Binary file - RTC SLA Tentacles backend Worker component. """
    any_arch = True
    auto_backup = False
    executable = True
    releasable = True
    ttl = 14
    arcadia_build_path = "infra/rtc_sla_tentacles/backend/bin/worker/rtc-sla-tentacles-backend-worker"


class RtcSlaTentaclesUI(sdk2.Resource):
    """ Binary file - RTC SLA Tentacles UI resource. """
    any_arch = False
    auto_backup = True
    executable = False
    releasable = True
    releasers = ['INFRACLOUDUI', 'squirrel', 'rocco66']
