# coding: utf-8

from sandbox.projects.common.build.YaMake import YaMakeTask

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.nanny import nanny

import sandbox.projects.rtcbutler.resource_types as resource_types

RESOURCES = {
    'rtcbutler': resource_types.RtcbutlerServerBinary,
    'exporter': resource_types.RtcbutlerExporterBinary,
}


class BuildRtcbutler(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build rtcbutler project
    """
    type = 'BUILD_RTCBUTLER_SRV'

    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.ClearBuild,
    ]

    def get_resources(self):
        return {
            k: {'description': 'rtcbutler {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return [
            'search/mon/rtc/rtcbutler/bin/rtcbutler',
            'search/mon/rtc/rtcbutler/bin/exporter',
        ]

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
