# coding=utf-8
from __future__ import unicode_literals

import os
from shutil import copyfile

from sandbox import sdk2
from sandbox.projects.common import binary_task
from sandbox.projects.common.arcadia import sdk as arcadiasdk
from sandbox.projects.common.vcs import aapi


class GenerateRtcdutyReport(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Requirements(sdk2.Requirements):
        # configure this for your task, the more accurate - the better
        cores = 1  # exactly 1 core
        disk_space = 128  # 128 Megs or less
        ram = 128  # 128 Megs or less

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        # binary task release parameters
        yav_st_token = sdk2.parameters.YavSecret("Token for usage Startrek API", default="sec-01f2pc279kgg4kbwq2ft4kvtz3@ver-01f2pc27a11rf6d9a2swf2t712")
        support_queue = sdk2.parameters.String("ST Queue that will be searched for tickets", default="RTCSUPPORT")
        report_queue = sdk2.parameters.String("ST Queue to wich will be sended report", default="TEST")
        arcadia_head = sdk2.parameters.ArcadiaUrl("Svn url for arc with revision.", default_value="arcadia:/arc/trunk/arcadia")
        template_file = sdk2.parameters.String("Relative path in Arcadia to file with Jinja2 template of report", required=True)
        responsible_file = sdk2.parameters.String("Relative path in Arcadia to YAML-file with defenition Team - Responsible for team", required=True)
        summon_file = sdk2.parameters.String("Relative path in Arcadia to Summon Message file", required=True)
        ext_params = binary_task.binary_release_parameters(stable=True)

    @staticmethod
    def get_file_from_arcadia_trunk(arcadia_head, path_to_file, file_name):
        # Copying file from Arcadia trunk to CWD.
        revision = aapi.ArcadiaApi.svn_head()
        with arcadiasdk.mount_arc_path(
            sdk2.svn.Arcadia.replace(arcadia_head, revision=revision)
        ) as a_arcadia_path:
            copyfile(os.path.join(a_arcadia_path, path_to_file), os.path.join(os.getcwd(), file_name))

    def on_execute(self):
        st_token = self.Parameters.yav_st_token.data()["ST_TOKEN"]
        template_file = "report_template.jinja"
        responsible_file = "responsibles"
        summon_message_file = "summon_message"
        self.get_file_from_arcadia_trunk(self.Parameters.arcadia_head, self.Parameters.template_file, template_file)
        self.get_file_from_arcadia_trunk(self.Parameters.arcadia_head, self.Parameters.responsible_file, responsible_file)
        self.get_file_from_arcadia_trunk(self.Parameters.arcadia_head, self.Parameters.summon_file, summon_message_file)
        from search.mon.rtc.statistics.reports.rtcduty_report_lib.rtcduty_report import RtcDutyReporter
        reporter = RtcDutyReporter(report_template_file_path=template_file,
                                   responsible_file_path=responsible_file,
                                   summon_message_file_path=summon_message_file,
                                   st_token=st_token,
                                   support_queue=self.Parameters.support_queue,
                                   report_queue=self.Parameters.report_queue)
        reporter.generate_report()
