# coding: utf-8

from sandbox import sdk2
from sandbox.projects.resource_types.releasers import marty


class RtcbutlerResource(sdk2.Resource):
    """
    Abstract Rtcbutler resource.
    """
    releasable = True
    any_arch = False
    releasers = marty
    auto_backup = True


class RtcbutlerServerBinary(RtcbutlerResource):
    """
    RTC Butler server binary.
    """
    arcadia_build_path = 'search/mon/rtc/rtcbutler/bin/rtcbutler'


class RtcbutlerExporterBinary(RtcbutlerResource):
    """
    RTC Butler server binary.
    """
    arcadia_build_path = 'search/mon/rtc/rtcbutler/bin/exporter'
