# -*- coding: utf-8 -*-

import os
import shutil
import logging

from sandbox import sdk2
from sandbox.sdk2.helpers import subprocess
from sandbox.sdk2.helpers.process import ProcessLog
import sandbox.common.types.client as client_tags

from sandbox.projects.rtcc.base.mixin import (
    DynamicPlaceTask,
    ArcadiaRtccTask
)
from sandbox.projects.rtcc.resources import RtccDocs


class BuildRtccDocs(DynamicPlaceTask):
    """
    Build RTCC html docs from bunch of .rst files
    """

    class Parameters(ArcadiaRtccTask.Parameters):
        pass

    class Requirements(sdk2.Requirements):
        client_tags = client_tags.Tag.GENERIC

    @staticmethod
    def log_info(message):
        logging.info('<RTCC DOCS> {}'.format(message))

    def _generate_docs(self):
        rtcc_docs_path = os.path.join(self.get_rtcc_path(), 'docs')
        task_docs_path = str(self.path('docs'))
        self.log_info('Copying {} to {}'.format(rtcc_docs_path, task_docs_path))
        shutil.copytree(rtcc_docs_path, task_docs_path)

        self.log_info('Local docs path exists={}, isdir={}'.format(
            os.path.exists(task_docs_path), os.path.isdir(task_docs_path)))

        with ProcessLog(self, 'Make html') as pl:
            subprocess.Popen(
                ['make html'],
                shell=True,
                cwd=task_docs_path,
                stderr=pl.stderr, stdout=pl.stdout
            )

    def _create_resource(self):

        generated_docs = os.path.join(str(self.path('docs')), '_build', 'html')
        self.log_info('Local generated docs path exists={}, isdir={}'.format(
            os.path.exists(generated_docs), os.path.isdir(generated_docs)))

        sdk2.ResourceData(
            RtccDocs(self,
                     'Config generator documentation [from task {}]'.format(self.id),
                     path=os.path.join(str(self.path('docs')), '_build', 'html'))
        ).ready()

    def on_execute(self):
        with self.venv_with_rtcc_reqs(('docs', 'requirements.txt')):
            self._generate_docs()
        self._create_resource()
