# coding: utf-8

import sandbox.projects.rtcsupport.resource_types as resource_types

from sandbox.projects.common.build import parameters as build_params
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.nanny import nanny

RESOURCES = {
    'plotva': resource_types.PlotvaBinary,
}


class BuildPlotva(nanny.ReleaseToNannyTask, YaMakeTask):
    """
    Build plotva binary.
    """
    type = 'BUILD_PLOTVA'
    input_parameters = [
        build_params.ArcadiaUrl,
        build_params.BuildType,
        build_params.CheckReturnCode,
        build_params.CheckoutModeParameter,
        build_params.CheckoutParameter,
        build_params.UseArcadiaApiFuse,
        build_params.AllowArcadiaApiFallback,
        build_params.ClearBuild,
        nanny.StartrekTicketIdsParameter
    ]

    def get_resources(self):
        return {
            k: {'description': 'plotva {}'.format(k), 'resource_path': k, 'resource_type': rtype}
            for k, rtype in RESOURCES.iteritems()
        }

    def get_targets(self):
        return [
            'search/mon/rtc/plotva/app_bin',
        ]

    def get_arts(self):
        return [{'dest': '', 'path': "{}/{}".format(rtype.arcadia_build_path, k)} for k, rtype in RESOURCES.iteritems()]
