# coding: utf-8

from sandbox import sdk2
from sandbox.projects.rthub.resources import RTHubTestOutput, RTHubDiffTool
from os.path import join as pj
import os
import subprocess


class RTHubTestDiff(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class CompareRTHubTestOutputs(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        new_test_out = sdk2.parameters.Resource(
            "New RTHub test output",
            resource_type=RTHubTestOutput,
            required=True
        )
        prev_test_out = sdk2.parameters.Resource(
            "Previous RTHub test output",
            resource_type=RTHubTestOutput,
            required=True
        )
        diff_tool = sdk2.parameters.Resource(
            "diff_tool for rthub outputs",
            resource_type=RTHubDiffTool,
            required=True
        )

    def on_execute(self):
        new_output_res = sdk2.ResourceData(self.Parameters.new_test_out)
        prev_output_res = sdk2.ResourceData(self.Parameters.prev_test_out)
        diff_tool_res = sdk2.ResourceData(self.Parameters.diff_tool)
        diff_tool = str(diff_tool_res.path)

        has_diff_exit_code = 1
        diff_tool_cmd = [
            pj(diff_tool, 'diff_tool'),
            str(prev_output_res.path),
            str(new_output_res.path),
            '--config', pj(diff_tool, 'config.pb.txt'),
            '--protos', pj(diff_tool, 'data/protos'),
            '--use-binary-format'
        ]
        diff_output_path = pj(os.getcwd(), 'diff.txt')
        with open(diff_output_path, 'w') as f:
            diff_tool_exit_code = subprocess.Popen(diff_tool_cmd, stdout=f).wait()
        if diff_tool_exit_code not in (0, has_diff_exit_code):
            raise RuntimeError('diff_tool failed with exit_code [{0}], please check task error output'
                               .format(diff_tool_exit_code))

        self.Context.has_diff = diff_tool_exit_code == has_diff_exit_code
        out_resource = sdk2.Resource['RTHUB_TEST_DIFF'](
            self,
            "Diff between canonical and test outputs from task {}".format(self.id),
            diff_output_path
        )
        out_resource_data = sdk2.ResourceData(out_resource)
        out_resource_data.ready()

        self.Context.cmp_results_res_id = out_resource.id
