import logging
import time

import sandbox.common.types.task as ctt

from sandbox import common
from sandbox import sdk2


class DeployRTHubStaging(sdk2.Task):
    """
    Deploy RTHub packageas to staging.
    """

    tasks_to_release = {}

    class Parameters(sdk2.Task.Parameters):
        pages_task_id = sdk2.parameters.Task(
            "RTHub Pages build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        pages_fresh_task_id = sdk2.parameters.Task(
            "RTHub Pages Fresh build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        sitemaps_task_id = sdk2.parameters.Task(
            "RTHub Sitemaps build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        hosts_task_id = sdk2.parameters.Task(
            "RTHub Hosts build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        app_docs_task_id = sdk2.parameters.Task(
            "RTHub AppDocs build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        lb_balancer_task_id = sdk2.parameters.Task(
            "RTHub LB balancer build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )
        images_task_id = sdk2.parameters.Task(
            "RTHub Images build task_id",
            task_type="BUILD_RTHUB_PACKAGE"
        )

    def release_task(self, build_type, build_task, release_type):
        if build_task.status not in ctt.Status.Group.SUCCEED:
            raise common.errors.TaskFailure("Task to release is in failed status!!!")

        rest_client = common.rest.Client()
        logging.info("Releasing {} to {}".format(build_task.id, release_type))
        payload = {
            "task_id": build_task.id,
            "cc": [],
            "to": [],
            "params": {},
            "message": "Auto-release of {} by DeployRTHubStaging".format(build_type),
            "type": release_type,
            "subject": "Auto-release of {} by DeployRTHubStaging.".format(build_type),
        }
        rest_client.release(payload)
        while rest_client.task[build_task.id].read()['status'] != 'RELEASED':
            time.sleep(60)

    def on_execute(self):
        if self.Parameters.pages_task_id:
            self.tasks_to_release['Pages'] = self.Parameters.pages_task_id
        if self.Parameters.pages_fresh_task_id:
            self.tasks_to_release['PagesFresh'] = self.Parameters.pages_fresh_task_id
        if self.Parameters.sitemaps_task_id:
            self.tasks_to_release['Sitemaps'] = self.Parameters.sitemaps_task_id
        if self.Parameters.hosts_task_id:
            self.tasks_to_release['Hosts'] = self.Parameters.hosts_task_id
        if self.Parameters.app_docs_task_id:
            self.tasks_to_release['AppDocs'] = self.Parameters.app_docs_task_id
        if self.Parameters.lb_balancer_task_id:
            self.tasks_to_release['LBBalancer'] = self.Parameters.lb_balancer_task_id
        if self.Parameters.images_task_id:
            self.tasks_to_release['Images'] = self.Parameters.images_task_id

        if self.tasks_to_release:
            for build_type, task_id in self.tasks_to_release.items():
                self.release_task(
                    build_type,
                    task_id,
                    'unstable'
                )
        else:
            raise common.errors.TaskFailure("Nothing to release!!!")

    @property
    def footer(self):
        footer_data = '<h4>Tasks to release:</h4><br />'
        for build_type, task_id in self.tasks_to_release:
            footer_data += '{0}: <a href="https://sandbox.yandex-team.ru/task/{1}">{1}</a><br />'.format(build_type, task_id)

        return footer_data
