import logging
import os
import re

from sandbox import sdk2
from sandbox import common
from sandbox.projects.common.nanny import nanny

from os.path import join as pj
from shutil import copy


class PrepareRTHubResourcesForRelease(sdk2.Task, nanny.ReleaseToNannyTask2):
    """
    Prepare sandbox RTHub resources for release.

    """

    class Parameters(sdk2.Task.Parameters):
        checkout_arcadia_from_url = sdk2.parameters.ArcadiaUrl(
            "Arcadia url",
            default_value="arcadia:/arc/trunk/arcadia",
            required=True
        )
        resources_list = sdk2.parameters.String(
            "List of resources to prepare (';'-separated)",
            required=True
        )
        package = sdk2.parameters.String(
            "RTHub packages name from which to get reource id.",
            required=True
        )

    def on_execute(self):
        ya_make_dir = pj(os.curdir, "{}".format(self.Parameters.package))
        self.Context.resources_for_release = ''

        sdk2.svn.Arcadia.checkout(
            url="{}/robot/rthub/packages/resources/{}".format(self.Parameters.checkout_arcadia_from_url, self.Parameters.package),
            path=ya_make_dir
        )

        res_list = self.Parameters.resources_list.split(';')
        for res in res_list:
            logging.info("Searching for {} resource id...".format(res))
            with open(pj(ya_make_dir, "ya.make"), "r") as lines:
                for line in lines:
                    m = re.search("FROM_SANDBOX\(FILE ([0-9]+) OUT_NOAUTO {}".format(res), line)
                    if m:
                        res_id = m.group(1)

            if res_id:
                orig_resource = sdk2.Resource.find(id=res_id).first()
                orig_resource_data = sdk2.ResourceData(orig_resource)
                orig_resource_path = str(orig_resource_data.path)

                os.mkdir(pj(os.curdir, res))
                print "CurDir: {}".format(os.curdir)
                copy(orig_resource_path, pj(os.curdir, res))

                new_resource = sdk2.Resource[res](
                    self,
                    "Copy of resource {}: {} for release.".format(res, res_id),
                    pj(res, "{}.tar".format(res))
                )
                new_resource_data = sdk2.ResourceData(new_resource)
                new_resource_data.ready()
                self.Context.resources_for_release += "{}, ".format(str(new_resource.id))
            else:
                logging.error("Resource {} was not found in {} ya.make".format(res, self.Parameters.package))
                raise common.errors.TaskFailure("Resource {} was not found in {} ya.make".format(res, self.Parameters.package))

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
