from sandbox import sdk2

rthub_releasers = [
    'izetag',
    'robot-rthub',
    'zagevalo',
    'ulgen4a',
    'vlavrenchenko',
    'bikulov',
    'antervis',
    'lazv85',
    'itelichko',
    'akhovrychev',
    'gous32',
    'alex-stanovoy',
    'robot-srch-releaser',
    'robot-testenv'
]

turbo_releasers = [
    'alpustovalova',
    'bogolubsky',
    'egorshelk',
    'ilyakuchumov',
    'nshal',
    'rihter007',
    'shubert',
    'web-chib',
    'pzuev',
    'robot-testenv',
    'dav1m',
    'sagishev',
    'alexbuchkin',
    'starcev',
    'lokehoke',
    'mhuman',
    'nik-lozhkarev',
    'alexander-tr',
    'gershgorin',
    'diigl',
    'mihailgribov',
    'kogutivan',
    'dmitrysluch',
    'romariogi',
    'miklop',
    'alexchern',
    'ivanvazhenin',
    'sloskutnikov',
    'vvkrivolapov',
]

adv_releasers = [
    'mmatrosova',
    'swarmer'
]

alice_releasers = [
    'akhruslan',
    'a-square',
    'g-kostin',
    'zubchick'
]

rthub_core_releasers = [
    'knuzhdin',
    'vtroitsky',
    'robot-skc',
    'itelichko',
    'uzhas',
    'hor911'
]

geosearch_releasers = [
    'yu-semichev'
]

rthub_subscribers = ['rthub_releasers']


class YqlUdfPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubBinsPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubConfigsFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubPagesFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubPagesFreshFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubTurboFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers + turbo_releasers
    release_subscribers = rthub_subscribers


class RthubGeoSearchFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers + geosearch_releasers
    release_subscribers = rthub_subscribers


class RthubIzolentaFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubIzolentaImagesFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubAppDocsFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubHostsFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubImagesFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubSitemapsFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RTHubTestData(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers
    # custom
    test_data_kind = sdk2.Attributes.String("Type of the test data", required=False)


class RTHubTestOutput(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class CanonRTHubTestResults(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class RTHubDiffTool(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class RTHubCmpy(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True


class RTHubLbBalancerFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RTHubAliceLbBalancerFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers + alice_releasers
    release_subscribers = rthub_subscribers + alice_releasers


class RTHubKwytViewerFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class YqlUdfContentPluginsConfigs(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers + turbo_releasers
    release_subscribers = rthub_subscribers


class YqlUdfImagesIparserConfig(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubRtlogPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_subscribers


class RthubAdvWidgetFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers + adv_releasers
    release_subscribers = rthub_subscribers


class RthubCiFullPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_core_releasers


class RthubCiBalancerPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_core_releasers


class RthubCiShooterPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_core_releasers


class RthubPagesResourcesPackage(sdk2.Resource):
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers


class RthubConfigs(sdk2.Resource):
    name = 'RTHUB_CONFIGS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_releasers
    arcadia_build_path = 'robot/rthub/conf'
    res_type = 'vcs'


class RthubScripts(sdk2.Resource):
    name = 'RTHUB_SCRIPTS'
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_releasers
    arcadia_build_path = 'robot/rthub/scripts'
    res_type = 'vcs'


class RthubBolirol(sdk2.Resource):
    name = 'RTHUB_POLIROL'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_releasers
    arcadia_build_path = 'robot/rthub/tools/balancer_polirol'
    bin_name = 'balancer_polirol'
    res_type = 'build'

class RthubPartitionsMonitor(sdk2.Resource):
    name = 'RTHUB_PARTITIONS_MONITOR'
    any_arch = True
    executable = True
    auto_backup = True
    calc_md5 = True
    share = True
    releasable = True
    releasers = rthub_releasers
    release_subscribers = rthub_releasers
    arcadia_build_path = 'robot/rthub/tools/partitions_monitor'
    bin_name = 'partitions_monitor'
    res_type = 'build'
