# -*- coding: utf-8 -*-

import logging
import os
import tempfile

from sandbox import sdk2
from sandbox.projects.common import constants as consts
from sandbox.projects.common.arcadia import sdk
from sandbox.projects.common.nanny.nanny import ReleaseToNannyTask2
from sandbox.projects.infra.common import get_arcadia


class RtmrYqlYdbSliSolomonMetricsExporterBinary(sdk2.Resource):
    executable = True
    releasable = True
    releasers = ["slonnn"]
    auto_backup = True
    arcadia_build_path = "rtmapreduce/monitoring/yql_sli/ydb_to_solomon_metrics_exporter"


class BuildRtmrYqlYdbSliSolomonMetricsExporter(ReleaseToNannyTask2, sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl("Svn url for arcadia", required=True)
        test = False

        with sdk2.parameters.Output:
            data_resource = sdk2.parameters.Resource("Binary", resource_type=RtmrYqlYdbSliSolomonMetricsExporterBinary)

    class Context(sdk2.Task.Context):
        data_name = "binary"

    def on_execute(self):
        self.Parameters.data_resource = RtmrYqlYdbSliSolomonMetricsExporterBinary(
            self, self.Parameters.description, self.Context.data_name, ttl=90
        )

        self.build()

    def build(self):
        target = RtmrYqlYdbSliSolomonMetricsExporterBinary.arcadia_build_path
        build_dir = tempfile.mkdtemp()

        with get_arcadia(self.Parameters.arcadia_url) as arcadia:
            logging.info("build nodes_not_in_use  binary...")
            sdk.do_build(
                consts.YMAKE_BUILD_SYSTEM,
                source_root=arcadia,
                build_type=consts.RELEASE_BUILD_TYPE,
                targets=[target],
                results_dir=build_dir,
                clear_build=True,
                test=self.Parameters.test,
            )
            logging.info("binary built")

        os.rename(os.path.join(build_dir, target), str(self.Parameters.data_resource.path))

    def on_release(self, additional_parameters):
        ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
