# -*- coding: utf-8 -*-

from sandbox import sdk2

import sandbox.projects.rtmr.resources as rtmr_resources
import sandbox.projects.rtmr.common as rtmr_common

from sandbox.projects.rtmr.RtmrDeployGraphYF import RtmrDeployGraphYF


class RtmrGraphDeploy(sdk2.Task):
    """Deploy graph to YF"""

    class Requirements(sdk2.Task.Requirements):
        cores = 1
        disk_space = 1024  # 1Gb

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        description = "Deploy graph to YFhost"
        kill_timeout = 3 * 60 * 60  # 3 hours

        cluster = sdk2.parameters.String("Cluster name", required=True)

        build_task = sdk2.parameters.Task(
            "RTMR_GRAPH_RELEASE task used to build artifacts",
            required=True)

        graph = sdk2.parameters.String(
            "Name of graph to deploy",
            required=True)

        with sdk2.parameters.Group("Deploy to YF settings") as yf_settings:
            rtmr_deploy_resource = rtmr_common.LastResource(
                "RTMR Deploy Tool",
                resource_type=rtmr_resources.RtmrDeployTool,
                required=True
            )

            slots = sdk2.parameters.Integer(
                "Number of slots for YF function",
                default=None)

            oauth_token_name = sdk2.parameters.String(
                "Vault secret name with rtmr-deploy OAuth token",
                default="rtmr_deploy_usertask_yf_oauth_token",
                required=True)

            cleanup_missing = sdk2.parameters.Bool(
                "Delete tasks not present in the generated config",
                default=False)

    class Context(sdk2.Task.Context):
        deploy_task_ids = list()

    def deploy_to_yf(self):
        self.set_info("Deploy usertasks to YF")

        task = RtmrDeployGraphYF(
            self,
            description="Deploy usertasks to YF on cluster " + self.Parameters.cluster,
            priority=self.Parameters.priority,
            cluster=self.Parameters.cluster,
            graph=self.Parameters.graph,
            rtmr_deploy_resource=self.Parameters.rtmr_deploy_resource,
            build_task=self.Parameters.build_task.id,
            slots=self.Parameters.slots,
            oauth_token_name=self.Parameters.oauth_token_name,
            cleanup_missing=self.Parameters.cleanup_missing
        )

        task.save().enqueue()

        self.Context.deploy_task_ids.append(task.id)
        self.Context.save()

    def on_execute(self):
        with self.memoize_stage.deploy_to_yf(commit_on_entrance=False):
            self.deploy_to_yf()

        with self.memoize_stage.wait_deploy_task(commit_on_entrance=False, commit_on_wait=False):
            rtmr_common.wait_tasks(self.Context.deploy_task_ids)
