# -*- coding: UTF-8 -*-

import os
import json

from sandbox import sdk2
import sandbox.common.types.client as ctc


class RtmrPrepareUsertasksReleaseMeta(sdk2.Task):
    """Load config from file for RTMR usertasks release"""

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        disk_space = 2 * 1024  # 2Gb

    class Parameters(sdk2.Task.Parameters):
        description = "Load config from file for RTMR usertasks release"
        kill_timeout = 5 * 60
        execution_space = 1000

        arcadia_config_path = sdk2.parameters.ArcadiaUrl(
            "RTMR Release config path",
            required=True,
            default_value="arcadia:/arc/trunk/arcadia/rtmapreduce/ci/testenv/"
        )

        config_name = sdk2.parameters.String(
            "RTMR Release config file",
            required=False,
            default_value="usertasks_all.json"
        )

    def on_execute(self):
        arc_path = sdk2.vcs.svn.Arcadia.get_arcadia_src_dir(self.Parameters.arcadia_config_path)

        cfg_path = os.path.join(arc_path, self.Parameters.config_name)

        with open(cfg_path) as json_file:
            cfg = json.load(json_file)

        self.Context.cfg_arcadia_url = cfg["arcadia_url"]
        self.Context.cfg_clusters = cfg["clusters"]
        self.Context.cfg_tasks = ",".join(cfg["tasks"])
        self.Context.cfg_tasks_list = cfg["tasks"]
