# -*- coding: UTF-8 -*-

import os

from sandbox import sdk2
import sandbox.common.types.client as ctc
from sandbox.sdk2.helpers import subprocess as sp


class RtmrUpdateSolomonTriggers(sdk2.Task):
    """Update Solomon triggers for RTMR"""

    class Requirements(sdk2.Task.Requirements):
        client_tags = ctc.Tag.Group.LINUX
        disk_space = 2 * 1024  # 2Gb

    class Parameters(sdk2.Task.Parameters):
        description = "Update Solomon triggers for RTMR"
        kill_timeout = 5 * 60
        execution_space = 100

        triggers_url = sdk2.parameters.ArcadiaUrl(
            "RTMR Scripts path",
            required=True,
            default_value="arcadia:/arc/trunk/arcadia/rtmapreduce/monitoring/solomon"
        )
        solomon_secret_name = sdk2.parameters.String(
            "Vault secret name with Solomon OAuth token",
            required=True,
            default_value="rtmr-solomon-oauth"
        )
        dry_run = sdk2.parameters.Bool("Dry Run", default_value=False)
        verbose = sdk2.parameters.Bool("Verbose", default_value=False)

    def on_execute(self):
        environment = os.environ.copy()
        environment["SOLOMON_OAUTH_TOKEN"] = sdk2.Vault.data(self.Parameters.solomon_secret_name)
        triggers_path = sdk2.vcs.svn.Arcadia.get_arcadia_src_dir(self.Parameters.triggers_url)
        cmd_path = os.path.join(triggers_path, "update_triggers.py")
        cmd = [cmd_path]
        if self.Parameters.dry_run:
            cmd.append("--dry-run")
        if self.Parameters.verbose:
            cmd.append("--verbose")
        proc = sp.Popen(cmd, stdout=sp.PIPE, stderr=sp.STDOUT, env=environment)
        stdout, _ = proc.communicate()
        if len(stdout) > 0:
            self.set_info(stdout)
        if proc.returncode != 0:
            raise Exception("Failed to update triggers")
