# -*- coding: UTF-8 -*-

import os
import six
import sys

from sandbox import sdk2
from sandbox.projects.rtmr.singleton import Singleton


class RtmrAccountsInfo(six.with_metaclass(Singleton)):
    CONFIG_URL = "arcadia:/arc/trunk/arcadia/rtmapreduce/config/src"

    def __init__(self):
        self._accounts = None

    def _update(self):
        if self._accounts is not None:
            return
        config_path = sdk2.Path("rtmr-py-config-src-accounts/src")
        config_path.mkdir(parents=True)
        dst = str(config_path.absolute())
        sdk2.vcs.svn.Arcadia.checkout(self.CONFIG_URL, dst, sdk2.vcs.svn.Arcadia.Depth.IMMEDIATES)
        sys.path.append(os.path.dirname(dst))
        from src.accounts import ACCOUNTS_FOR_YF_DIRECT
        self._accounts = ACCOUNTS_FOR_YF_DIRECT

    @property
    def accounts(self):
        self._update()
        return self._accounts
