# -*- coding: UTF-8 -*-

import os
import six
import sys

from sandbox import sdk2
from sandbox.projects.rtmr.singleton import Singleton


class RtmrClustersInfo(six.with_metaclass(Singleton)):
    CONFIG_URL = "arcadia:/arc/trunk/arcadia/rtmapreduce/config/src"

    def __init__(self):
        self._clusters = None

    def _update(self):
        if self._clusters is not None:
            return
        config_path = sdk2.Path("rtmr-py-config-src/src")
        config_path.mkdir(parents=True)
        dst = str(config_path.absolute())
        sdk2.vcs.svn.Arcadia.checkout(self.CONFIG_URL, dst, sdk2.vcs.svn.Arcadia.Depth.IMMEDIATES)
        sys.path.append(os.path.dirname(dst))
        from src.clusters import ClustersList
        self._clusters = ClustersList

    @property
    def clusters(self):
        self._update()
        return self._clusters


RTMR_CLUSTERS = {
    # Processing
    "rtmr-vla",
    "rtmr-sas",

    # Mirror
    # "rtmr-man-mirror",
    "rtmr-sas2-mirror",
    "rtmr-vla2-mirror",
    "rtmr-sas-test",

    # Dev clusters
    "rtmr-dev-man-2",
    "rtmr-dev-man-3",
    "rtmr-dev-man-5",
    "rtmr-man-prestable",
}
