# -*- coding: UTF-8

from sandbox import sdk2


class RtmrReleaseableResource(sdk2.Resource):
    releasable = True
    releasers = ["RTMR-DEV"]


class RtmrVersionedResource(RtmrReleaseableResource):
    branch = sdk2.parameters.String("Branch")
    revision = sdk2.parameters.String("Revision")


class RtmrReleaseDeb(RtmrReleaseableResource):
    """RTMR release Debian package"""
    auto_backup = True
    release_subscribers = ["rtmr-releases"]


class RtmrUserdata(RtmrReleaseableResource):
    """RTMR userdata binary"""
    pass


class RtmrUserdataDeb(RtmrReleaseableResource):
    """RTMR userdata Debian package"""
    release_subscribers = ["rtmr-releases"]


class RtmrConfigTool(RtmrReleaseableResource):
    """RTMR configuration utility"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrDeployTool(RtmrReleaseableResource):
    """RTMR deploy utility"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrDeployDarwinTool(RtmrReleaseableResource):
    """RTMR deploy utility (DARWIN)"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrRollingRestartTool(RtmrReleaseableResource):
    """RTMR rolling restart tool"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrPushTool(RtmrReleaseableResource):
    """RTMR push utility"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrYFClient(RtmrReleaseableResource):
    """YF Client"""
    auto_backup = True
    any_arch = False
    executable = True


class RtmrYFArtifacts(RtmrVersionedResource):
    """Uploaded artifact for a cluster"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


class RtmrPackageConfig(RtmrVersionedResource):
    """RTMR cluster packages config"""
    auto_backup = True


class RtmrUsertaskConfig(RtmrVersionedResource):
    """RTMR usertask config"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


class RtmrGraphConfig(RtmrVersionedResource):
    """RTMR graph config"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


class RtmrMirrorConfig(RtmrVersionedResource):
    """RTMR mirror config"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


class RtmrSourceConfig(RtmrVersionedResource):
    """RTMR source config"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


class RtmrQuoterConfig(RtmrVersionedResource):
    """RTMR Quoter config"""
    cluster = sdk2.parameters.String("RTMR Cluster name")


class RtmrUsertaskDeb(RtmrReleaseableResource):
    """RTMR usertask Debian package"""
    auto_backup = True
    release_subscribers = ["rtmr-releases"]


class RtmrPqoutPackage(RtmrReleaseableResource):
    """RTMR pqout package"""
    auto_backup = True
    release_subscribers = ["rtmr-releases"]


class RtmrYdboutPackage(RtmrReleaseableResource):
    """RTMR ydbout package"""
    auto_backup = True
    release_subscribers = ["rtmr-releases"]


class RtmrSolomonoutPackage(RtmrReleaseableResource):
    """RTMR solomonout package"""
    auto_backup = True
    release_subscribers = ["rtmr-releases"]


class RtmrSandboxTaskLauncher(RtmrReleaseableResource):
    """RTMR sandbox task launcher binary"""
    auto_backup = True


class RtmrZ2ReleaseTracker(RtmrReleaseableResource):
    """RTMR Z2 Release Tracker"""
    auto_backup = True


class RtmrReleaseTracker(RtmrReleaseableResource):
    """RTMR Release Tracker"""
    auto_backup = True

#########################
# TestEnv resources draft


class RtmrStorageDeb(RtmrReleaseDeb):
    """RTMR storage Debian package"""


class RtmrServerDeb(RtmrReleaseDeb):
    """RTMR server Debian package"""


class RtmrPusherDeb(RtmrReleaseDeb):
    """RTMR pusher Debian package"""


class RtmrProxyDeb(RtmrReleaseDeb):
    """RTMR proxy Debian package"""


class RtmrHostDeb(RtmrReleaseDeb):
    """RTMR host Debian package"""


class RtmrApphostDeb(RtmrReleaseDeb):
    """RTMR apphost Debian package"""


class RtmrStaticConfigDeb(RtmrReleaseDeb):
    """RTMR static config Debian package"""


class RtmrDaemonsConfig(RtmrVersionedResource):
    """RTMR daemons config"""
    auto_backup = True
    cluster = sdk2.parameters.String("RTMR cluster name")


#########################
# Outdated resource types

class RTMR_RELEASE_TAR(RtmrReleaseableResource):
    """RTMR release Fleur package"""
    calc_md5 = False
    share = False


class RTMR_USERTASK_RELEASE_DEB(RtmrReleaseableResource):
    """RTMR usertask release Debian package"""
    pass


class RTMR_USERDATA_TAR(RtmrReleaseableResource):
    """RTMR userdata tarball"""
    pass


class RTMR_MONITORING_TAR(RtmrReleaseableResource):
    """RTMR monitoring tarball"""
    pass


class RTMR_MONITORING_DEB(RtmrReleaseableResource):
    """RTMR monitoring Debian package"""
    pass


#########################
# Deploy resources

class RTMR_YQL_SLI_APP(sdk2.Resource):
    """RTMR Yql over rtmr sli"""
    releasable = True
    auto_backup = True
    releasers = ["RTMR-DEV", "CI"]


class RTMR_ABCD_PROVIDER_APP(sdk2.Resource):
    """RTMR ABCD provider"""
    releasable = True
    auto_backup = True
    releasers = ["RTMR-DEV", "CI"]


class RTMR_BILLING_APP(sdk2.Resource):
    """RTMR Billing"""
    releasable = True
    auto_backup = True
    releasers = ["RTMR-DEV", "CI"]
