from sandbox import sdk2

DEV_OPS = [
    'vavinov',
    'drewxa',
    'evgen',
    'sapa',
    'lo-r-d',
    'gavrilovp',
    'julia-trofim',
    'mptwinsen',
    'esnesgovorov',
]


class RtxServant(sdk2.Resource):
    """
        Samogon package with RTX server (quality/functionality/rtx/entity_catalog/server)
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = ['vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']


class RtxTrendsModels(sdk2.Resource):
    """
        RTX trends object models and other stats (quality/functionality/rtx/trends)
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True


class RtxTrendsContextModels(sdk2.Resource):
    """
        RTX trends context models (quality/functionality/rtx/trends)
    """
    any_arch = True
    executable = False
    auto_backup = True
    calc_md5 = True


class RtxPredictionTrie(sdk2.Resource):
    """
        RTX CTR prediction trie
    """
    any_arch = True
    executable = False
    auto_backup = False
    calc_md5 = True


class TrendsClicks(sdk2.Resource):
    """
        RTX Trends Clicks
    """
    releasable = True
    auto_backup = True
    releasers = ['robot-rtx-trends', 'lo-r-d']


class TrendsToPublication(sdk2.Resource):
    """
        RTX Trends to Publication
    """
    releasable = True
    auto_backup = True
    releasers = ['robot-rtx-trends', 'lo-r-d']
    release_subscribers = ['vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']


class OOTrendsToPublication(sdk2.Resource):
    """
        RTX OOTrends to Publication
    """
    releasable = True
    auto_backup = True
    releasers = ['robot-rtx-trends', 'lo-r-d']
    release_subscribers = ['vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']


class BromozelToPublication(sdk2.Resource):
    """
        RTX Bromozel to Publication
    """
    releasable = True
    auto_backup = True
    releasers = ['robot-rtx-trends', 'lo-r-d']
    release_subscribers = ['vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']


class TrendsYaStrokaConfig(sdk2.Resource):
    """
        RTX Trends Ya Stroka Config
    """
    releasable = True
    auto_backup = True
    releasers = ['robot-rtx-trends', 'lo-r-d', 'vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']
    release_subscribers = ['vavinov', 'myltsev', 'lo-r-d', 'mptwinsen']


class YaStrokaBinary(sdk2.Resource):
    """
        yastroka.yandex.net service executable (quality/functionality/rtx/trends/ya_stroka/)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = DEV_OPS + ['robot-srch-releaser']
