-- Author: {{ task.author }} {{ author_url }}
-- Task: {{ task_url }}

PRAGMA AnsiInForEmptyOrNullableItemsCollections;

{% if user_definitions %}
{{ user_definitions }}
{% endif %}

{% for param in params%}
SELECT
    Backtrace,
    SUM(Counter) AS `Counter`,
FROM RANGE(`{{ prefix }}`, "{{ param.begin_time }}", "{{ param.end_time }}")
WHERE TRUE{% if param.blacklist_filtration_top %}
    AND Top NOT IN ("{{ param.blacklist_filtration_top | join('", "') }}"){% endif %}
    AND Service IN ("{{ param.services | join('", "') }}")
{% if  param.whitelist_filtration %}{% for column, value in param.whitelist_filtration.iteritems() %}
    AND CAST({{ column }} AS STRING) = "{{ value }}" {% endfor %}{% endif %}
GROUP BY (
    {% if param.separations %}({{ param.separations | join(' ?? "null") || ";" || (') }} ?? "null") || ";" || {% endif %} Backtrace AS Backtrace
);
{% endfor %}
