# -*- coding: utf-8 -*-
import os
from datetime import date

from sandbox.projects.runtime_models.resources import WEB_RTMODELS_PLAN
from sandbox.sandboxsdk import environments
import sandbox.sdk2 as sdk2


class CreateWebRtModelsRequestsPlan(sdk2.Task):
    class Parameters(sdk2.Parameters):
        number_of_requests = sdk2.parameters.Integer("number_of_requests", hint=True, default=1000)
        yt_proxy_url = sdk2.parameters.String("yt_proxy", hint=True, default='hahn.yt.yandex.net')
        yt_token_secret_name = sdk2.parameters.String("yt_token_secret_name", hint=True, default='robot_itditp_yt_token')

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment("yandex-yt"),
            environments.PipEnvironment("yandex-yt-yson-bindings-skynet")
        ]

    def on_execute(self):
        import yt.wrapper as yt
        plan_file = 'plan.txt'
        plan_path = os.path.abspath(plan_file)
        yt.config["proxy"]["url"] = self.Parameters.yt_proxy_url
        yt.config["token"] = sdk2.Vault.data(self.owner, self.Parameters.yt_token_secret_name)
        now = date.today()
        table_name = now.strftime("%Y%m%d")
        cnt = 0
        with open(plan_file, 'w') as f:
            for row in yt.read_table("//home/eventlogdata/MsuseardataJupiterTier0/" + table_name):
                if row['event_type'] != 'SubSourceRequest':
                    continue
                data = row['event_data']
                pos = data.find("/rtmodels")
                if pos != -1:
                    l = data.rfind('\t') + 1
                    r = data.rfind('\n') + 1
                    f.write(data[l:r])
                    cnt += 1
                    if cnt == self.Parameters.number_of_requests:
                        break

        _ = WEB_RTMODELS_PLAN(
            self,
            WEB_RTMODELS_PLAN.name,
            plan_path,
            released='stable',
            ttl=31
        )
