import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildCaesarModelsShard02Package(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='CaesarModelsShard02',
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'CaesarModelsShard02': {
                'CaesarModelsShard02': [
                    {
                        'model_name': 'banner_torch_v_1',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': '1__home__ads__robot-online-pytorch__new_production_online_learning_tsar_ffn_2__tsar_processed_model',
                                'dump_key': 'BannerNamespaces',
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'banner_torch_v_2',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': '5__home__ads__robot-online-pytorch__densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'BannerNamespaces'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'banner_torch_v_3',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': '4__home__ads__ltp__production_learning__kaptar_pclick__model__tsar_processed_model',
                                'dump_key': 'KaptarPclickBanner'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'banner_torch_v_4',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': '10__home__ads__robot-online-pytorch__search_densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'BannerNamespaces'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'brutal_rsya_ctr_tsar_model',
                        'resource_type': 'BRUTAL_RSYA_CTR_TSAR_MODEL',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                            },
                            'owner': 'brutalman',
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'RsyaBcTorchV2BannerModel',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(hours=36),
                    },
                    {
                        'model_name': 'SearchBcTorchV2BannerModel',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "__home_ads_robot-online-pytorch_bc_search_torchv2_hitmodel_tanh",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'NomzodV1BannerModel',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "NomzodV1",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(hours=48),
                    },
                    {
                        'model_name': 'UserBodyRsyaV1',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "Userbody_RSYA_V1",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(days=8),
                    },
                    {
                        'model_name': 'TorchRsyaMultitarget',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "pytorch_multitarget_model",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(days=365),
                    },
                    {
                        'model_name': 'GalleryWithOffer',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {},
                            'id': 2879411800,
                            'owner': 'maxim-kuzin'
                        }
                    },
                    {
                        'model_name': 'GalleryWithOfferMlStorage',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "tg_model2",
                                "dump_key": "banner"
                            },
                            'owner': 'ADS-ML-STORAGE'
                        }
                    },
                    {
                        'model_name': 'GalleryQuorumMlStorage',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "tg_model_quorum",
                                "dump_key": "banner"
                            },
                            'owner': 'ADS-ML-STORAGE'
                        }
                    },
                    {
                        'model_name': 'DssmForOfferRetargeting',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "2022_01_21__2022_06_13.filtered_by_select_type",
                                "dump_key": "banner"
                            },
                            'owner': 'ADS-ML-STORAGE'
                        }
                    },
                    {
                        'model_name': 'DssmForInternationalOfferRetargeting',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "2022_03_13__2022_06_13.filtered_by_order_id",
                                "dump_key": "banner"
                            },
                            'owner': 'ADS-ML-STORAGE'
                        }
                    }
                ],
            }
        }
