import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildCaesarModelsShard03Package(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='CaesarModelsShard03',
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'CaesarModelsShard03': {
                'CaesarModelsShard03': [
                    {
                        'model_name': 'banner_brutal_search_ctr_v1',
                        'resource_type': 'SEARCH_CTR_TSAR_MODEL',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'CONTEXT',
                            'attrs': {
                                'released': 'stable',
                            },
                        },
                        'update_period': datetime.timedelta(hours=36),
                    },
                    {
                        'model_name': 'Rsya7DMultiStageBanner',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_7d_hitsplit",
                                "dump_key": "banner",
                            },
                        },
                    },
                    {
                        'model_name': 'NomzodV2BannerModel_71',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "NomzodV2",
                                "dump_key": "banner",
                            },
                        },
                        'update_period': datetime.timedelta(days=365),
                    },
                    {
                        'model_name': 'TorchL1Model',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "pytorch_l1_model_fixed",
                                "dump_key": "banner",
                            },
                        },
                    },
                    {
                        'model_name': 'TorchL1V2Model',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "pytorch_l1_model_regular",
                                "dump_key": "banner",
                            },
                        },
                    },
                    {
                        'model_name': 'UserBodyAdsearchV2',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                            },
                            'id': 2833206380,
                            'owner': 'deadinside',
                        },
                    },
                    {
                        'model_name': 'TorchRankLoss',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "banner",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "QID_banner_id",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "QID_order_id_qid",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'NewRmpTorchContextBannerModel',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "NewRmpTorchContext",
                                "dump_key": "banner",
                            },
                        },
                    },
                    {
                        'model_name': 'GalleryNewQuorumMlStorage_67',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "tg_new_quorum",
                                "dump_key": "banner"
                            },
                            'owner': 'ADS-ML-STORAGE'
                        }
                    },
                    {
                        'model_name': 'PoorProfilesTorchBannerModel_68',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "PoorProfilesTorch",
                                "dump_key": "banner"
                            }
                        }
                    },
                    {
                        'model_name': 'SohilBannerModel_73',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'owner': 'ADS-ML-STORAGE',
                            'attrs': {
                                "key": "Sohil",
                                "dump_key": "banner",
                            },
                        }
                    },
                    {
                        'model_name': 'kaptar_banner_torch_v2_74',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': 'KaptarV2',
                                'dump_key': 'KaptarPclickBanner'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'ProductGallery_75',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': 'pytorch_bko_pclick_model',
                                'dump_key': 'banner'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    }
                ],
            }
        }
