import sandbox.projects.common.build.parameters as build_params
import sandbox.projects.common.constants as consts

from sandbox.projects.common.build.ya_package_config import consts as ya_package_consts
from sandbox.projects.common.build.KosherYaPackage import KosherYaPackage
from sandbox.projects.common.ya_deploy import release_integration

import sandbox.projects.runtime_models.components.yabs.resources as yabs_resources


HIT_MODELS_LAYERS_RESOURCES = [
    yabs_resources.RsyaHitModelsLightShard01NannyLayer,
    yabs_resources.RsyaHitModelsHeavyShard01NannyLayer,
]


def build_packages_param(packages_resources):
    packages_list = [resource.arcadia_build_path for resource in packages_resources]
    return ';'.join(packages_list)


def build_resource_type_param(packages_resources):
    resource_type_names = [resource.name for resource in packages_resources]
    return ';'.join(resource_type_names)


class BuildRsyaHitModelsLayers(KosherYaPackage):

    class Requirements(KosherYaPackage.Requirements):
        pass

    class Parameters(KosherYaPackage.Parameters):
        resource_type = build_params.ResourceType(default_value=build_resource_type_param(HIT_MODELS_LAYERS_RESOURCES))
        packages = build_params.Packages(default_value=build_packages_param(HIT_MODELS_LAYERS_RESOURCES))
        build_type = build_params.BuildType(default_value=consts.RELEASE_BUILD_TYPE)
        publish_package = build_params.PublishPackage(default_value=False)
        release_to_ya_deploy = release_integration.ReleaseToYaDeployParameter2(default_value=True)
        package_type = build_params.PackageType(default_value=ya_package_consts.PackageType.TARBALL.value)

    def on_enqueue(self):
        super(BuildRsyaHitModelsLayers, self).on_enqueue()

    def on_release(self, additional_parameters):
        super(BuildRsyaHitModelsLayers, self).on_release(additional_parameters)
