import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildRsyaUserBodyModelsPackage(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='RsyaUserBody',
            bg_shards={'RsyaUserBody'},
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'RsyaUserBody': {
                'Models': [
                    {
                        'model_name': 'RsyaUserBodyV1',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "Userbody_RSYA_V1",
                                        "dump_key": "hit",
                                    },
                                }
                            },
                        ],
                        'update_period': datetime.timedelta(days=8),
                    },
                ]
            }
        }
