import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildYabsHitModelsPackage(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='YabsHitModelsShard',
            bg_shards={'YabsHitModelsShard', 'YabsHitModelsShard02', 'YabsHitModelsShard03', 'YabsHitModelsLightShard'},
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'YabsHitModelsShard': {
                'TsarModels': [
                    {
                        'model_name': 'geodata6.bin',
                        'resource_type': 'GEODATA6BIN_STABLE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'GEOBASE',
                        },
                        'update_period': datetime.timedelta(hours=30),
                    },
                    {
                        'model_name': 'brutal_incremental_dssm',
                        'resource_type': 'BRUTAL_TSAR_MODEL',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                            },
                            'owner': 'brutalman',
                        },
                        'update_period': datetime.timedelta(days=14),
                    },
                    {
                        'model_name': 'brutal_rsya_ctr_tsar_model',
                        'resource_type': 'BRUTAL_RSYA_CTR_TSAR_MODEL',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                            },
                            'owner': 'brutalman',
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'ml_storage_rsya_bc_torchv2_user',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                                        "dump_key": "user_page",
                                    },
                                }
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_hitsplit",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ],
                        'update_period': datetime.timedelta(hours=36),
                    },
                    {
                        'model_name': 'TorchRsyaMultitarget',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_multitarget_model",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_multitarget_model",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_multitarget_model",
                                        "dump_key": "user_top_level",
                                    },
                                },
                            },
                        ],
                        'update_period': datetime.timedelta(days=365),
                    },
                    {
                        'model_name': 'Rsya7DMultiStageHitModel',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_7d_hitsplit",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_7d_hitsplit",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_bc_rsya_torchv2_7d_hitsplit",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'PYTORCH_L1_83',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_fixed",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_fixed",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_fixed",
                                        "dump_key": "user_top_level",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'PYTORCH_L1_V2_83',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_regular",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_regular",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_l1_model_regular",
                                        "dump_key": "user_top_level",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'BRUTAL_RSYA_CTR_MODEL_V2_84',
                        'resource_type': 'BRUTAL_RSYA_CTR_TSAR_MODEL_2',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                            },
                            'owner': 'brutalman',
                        },
                        'update_period': datetime.timedelta(hours=72),
                    },
                    {
                        'model_name': 'RsyaRankLossUserModel',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "top",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "user",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "rank_loss_model",
                                        "dump_key": "QID_page_id",
                                    },
                                },
                            }
                        ]
                    }
                ]
            },
            'YabsHitModelsShard02': {
                'TsarModels': [
                    {
                        'model_name': 'geodata6.bin',
                        'resource_type': 'GEODATA6BIN_STABLE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'GEOBASE',
                        },
                        'update_period': datetime.timedelta(hours=30),
                    },
                    {
                        'model_name': 'tsar_dssm',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1338416714,
                            'owner': 'jruziev',
                        },
                    },
                    {
                        'model_name': 'tsar_difacto_models',
                        'resource_type': 'TSAR_DUMPS_LIST',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'ADS_ONLINE_LEARNING',
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'ml_storage_pytorch_tsar_models',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                "key": "1__home__ads__robot-online-pytorch__new_production_online_learning_tsar_ffn_2__tsar_processed_model",
                                "dump_key": "UserNamespaces_3",
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'brutalman_search_ctr_model',
                        'resource_type': 'SEARCH_CTR_TSAR_MODEL',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'CONTEXT',
                            'attrs': {
                                'released': 'stable',
                            },
                        },
                        'update_period': datetime.timedelta(hours=36),
                    },
                    {
                        'model_name': 'tsar_future_prgg',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1589954382,
                            'owner': 'egorkudr1',
                        },
                    },
                    {
                        'model_name': 'tsar_ab',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1589892031,
                            'owner': 'egorkudr1',
                        },
                    },
                    {
                        'model_name': 'tsar_dssm_alb_fresh',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1597931701,
                            'owner': 'jruziev',
                        },
                    },
                    {
                        'model_name': 'basyl_bc_rsya_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1662260372,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'basyl_pclick_rsya_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1720301278,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'basyl_bc_key_goals_rsya_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1792063132,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'basyl_ab_conv_rsya_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1792075095,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'autotargeting_match_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360745572,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'SearchBcTorchV2HitModel',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "__home_ads_robot-online-pytorch_bc_search_torchv2_hitmodel_tanh",
                                "dump_key": "user",
                            },
                        },
                        'update_period': datetime.timedelta(hours=36),
                    },
                ]
            },
            'YabsHitModelsShard03': {
                'TsarModels': [
                    {
                        'model_name': 'geodata6.bin',
                        'resource_type': 'GEODATA6BIN_STABLE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'GEOBASE',
                        },
                        'update_period': datetime.timedelta(hours=30),
                    },
                    {
                        'model_name': 'tsar_dssm_search',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1338402966,
                            'owner': 'jruziev',
                        },
                    },
                    {
                        'model_name': 'tsar_organic_conv_search',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1633641241,
                            'owner': 'mixagol',
                        },
                    },
                    {
                        'model_name': 'query_banner_dssm',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1625663443,
                            'owner': 'nadalexey',
                        },
                    },
                    {
                        'model_name': 'basyl_bc_search_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1720280089,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'basyl_pclick_search_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1720270874,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'basyl_apc_search_model',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'id': 1736164390,
                            'owner': 'blv1mk',
                        },
                    },
                    {
                        'model_name': 'torch_v2_model_float16',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': '5__home__ads__robot-online-pytorch__densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'UserNamespaces_3'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'kaptar_ltp_user',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                "key": "4__home__ads__ltp__production_learning__kaptar_pclick__model__tsar_processed_model",
                                "dump_key": "KaptarPclickUser",
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'torch_v2_search_ctr_model',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,
                        'constraints': {
                            'attrs': {
                                'key': '10__home__ads__robot-online-pytorch__search_densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'UserNamespaces_3'
                            },
                        },
                        'update_period': datetime.timedelta(hours=24),
                    },
                    {
                        'model_name': 'autotargeting_exact_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360754582,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'autotargeting_accessory_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360762693,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'autotargeting_alternative_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360748316,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'autotargeting_broader_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360750344,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'autotargeting_competitor_dssm_embed32',
                        'resource_type': 'OTHER_RESOURCE',
                        'constraints': {
                            'id': 2360754625,
                            'owner': 'BROADMATCH',
                        },
                    },
                    {
                        'model_name': 'ProductGalleryPclick_105',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "pytorch_bko_pclick_model",
                                        "dump_key": "user",
                                    },
                                },
                            },
                        ],
                    },
                ]
            },
            'YabsHitModelsLightShard': {
                'TsarModels': [
                    {
                        'model_name': 'geodata6.bin',
                        'resource_type': 'GEODATA6BIN_STABLE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'owner': 'GEOBASE',
                        },
                        'update_period': datetime.timedelta(hours=30),
                    },
                    {
                        'model_name': 'l1model_with_ltp_and_bc_35',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                            },
                            'id': 2255391848,
                            'owner': 'iblinnikov',
                        },
                    },
                    {
                        'model_name': 'l1model_with_ltp_and_bc_v2_64',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                            },
                            'id': 2413800218,
                            'owner': 'iblinnikov',
                        },
                    },
                    {
                        'model_name': 'spyhit_rt_context_multistage',
                        'resources': [
                            {
                                'resource_type': 'ADV_MACHINE_DATA_HIT_MODELS_DSSM',
                                'constraints': {
                                    'owner': 'ADV_MACHINE',
                                    'attrs': {
                                        "released": "stable",
                                        "model": "spyhit_rt.apply",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ADV_MACHINE_DATA_HIT_MODELS_DSSM',
                                'constraints': {
                                    'owner': 'ADV_MACHINE',
                                    'attrs': {
                                        "released": "stable",
                                        "model": "spy_hit_context.apply",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'spyhit_rmp_rt_dssm',
                        'resource_type': 'ADV_MACHINE_DATA_HIT_MODELS_DSSM',
                        'constraints': {
                            'owner': 'ADV_MACHINE',
                            'attrs': {
                                "released": "stable",
                                "model": "spyhit_rmp_rt.apply",
                            }
                        },
                    },
                    {
                        'model_name': 'NomzodV1HitModel',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV1",
                                        "dump_key": "user_ltp",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV1",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV1",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV1",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ],
                        'update_period': datetime.timedelta(hours=48),
                    },
                    {
                        'model_name': 'NomzodV2HitModel_71',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV2",
                                        "dump_key": "user_ltp",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV2",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV2",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "NomzodV2",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'SpyHitRTPoorProfiles_76',
                        'resources': [
                            {
                                'resource_type': 'CRYPTA_SPY_HIT_POOR_PROFILES_RT_MODEL',
                                'constraints': {
                                    'owner': 'CRYPTA',
                                    'attrs': {
                                        "released": "stable",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'NewRmpTorchModel',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADVQUALITY',
                                    'attrs': {
                                        "key": "NewRmpTorch",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADVQUALITY',
                                    'attrs': {
                                        "key": "NewRmpTorch",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'NewRmpTorchModelContext',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADVQUALITY',
                                    'attrs': {
                                        "key": "NewRmpTorchContext",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADVQUALITY',
                                    'attrs': {
                                        "key": "NewRmpTorchContext",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADVQUALITY',
                                    'attrs': {
                                        "key": "NewRmpTorchContext",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'SpyHitRTPoorProfilesV2_79',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {},
                            'id': 2737190404,
                            'owner': 'CRYPTA',
                        },
                    },
                    {
                        'model_name': 'SPY_HIT_CONTEXT_V2_81',
                        'resource_type': 'OTHER_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {},
                            'id': 2810734642,
                            'owner': 'CRYPTA',
                        },
                    },
                    {
                        'model_name': 'SPY_HIT_RMP_CONTEXT_82',
                        'resources': [
                            {
                                'resource_type': 'ADV_MACHINE_DATA_HIT_MODELS_DSSM',
                                'constraints': {
                                    'owner': 'ADV_MACHINE',
                                    'id': 2813764647,
                                    'attrs': {
                                        "released": "stable",
                                        "model": "spyhit_rt.apply",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ADV_MACHINE_DATA_HIT_MODELS_DSSM',
                                'constraints': {
                                    'owner': 'ADV_MACHINE',
                                    'id': 3262175113,
                                    'attrs': {
                                        "released": "stable",
                                        "model": "spyhit_rt_rmp_context.apply",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'POOR_PROFILES_TORCH_MODEL_102',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "PoorProfilesTorch",
                                        "dump_key": "user_page",
                                    },
                                }
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "PoorProfilesTorch",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'attrs': {
                                        "key": "PoorProfilesTorch",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ]
                    },
                    {
                        'model_name': 'SohilHitModel_104',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "Sohil",
                                        "dump_key": "user_page",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "Sohil",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "Sohil",
                                        "dump_key": "user_top",
                                    },
                                },
                            },
                        ],
                    },
                    {
                        'model_name': 'MediationModel_110',
                        'resources': [
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_mediation_model",
                                        "dump_key": "user_profile",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_mediation_model",
                                        "dump_key": "adsystem_bid",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_mediation_model",
                                        "dump_key": "pagebid_top",
                                    },
                                },
                            },
                            {
                                'resource_type': 'ML_STORAGE_DUMP',
                                'source': StorageSources.ML_STORAGE,
                                'constraints': {
                                    'owner': 'ADS-ML-STORAGE',
                                    'attrs': {
                                        "key": "__home_ads_robot-online-pytorch_mediation_model",
                                        "dump_key": "pagectx",
                                    },
                                },
                            },
                        ],
                    },
                ],
            },
        }
