import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, StorageSources, get_build_models_package_parameters


PAGE_MODELS_RULE = 'YabsPageModels'


class BuildYabsPageModelsPackage(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default=PAGE_MODELS_RULE,
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            PAGE_MODELS_RULE: {
                PAGE_MODELS_RULE: [
                    {
                        'model_name': 'dump',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': '1__home__ads__robot-online-pytorch__new_production_online_learning_tsar_ffn_2__tsar_processed_model',
                                'dump_key': 'PageNamespacesConverted',
                            },
                        },
                        'update_period': datetime.timedelta(hours=5)
                    },
                    {
                        'model_name': 'dump_v2',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': '2__home__ads__robot-online-pytorch__densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'PageNamespacesConverted',
                            },
                        },
                        'update_period': datetime.timedelta(hours=5)
                    },
                    {
                        'model_name': 'dump_v4',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': '4__home__ads__ltp__production_learning__kaptar_pclick__model__tsar_processed_model',
                                'dump_key': 'KaptarPclickPageConverted',
                            },
                        },
                        'update_period': datetime.timedelta(hours=5)
                    },
                    {
                        'model_name': 'dump_v5',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': '5__home__ads__robot-online-pytorch__densenet_tsar_query_attention__tsar_processed_model',
                                'dump_key': 'PageNamespacesConverted',
                            },
                        },
                        'update_period': datetime.timedelta(hours=5)
                    },
                    {
                        'model_name': 'dump_v44',
                        'resource_type': 'ML_STORAGE_DUMP',
                        'source': StorageSources.ML_STORAGE,  # get id via mls client
                        'constraints': {
                            'attrs': {
                                'key': 'KaptarV2',
                                'dump_key': 'KaptarPclickPageConverted',
                            },
                        },
                        'update_period': datetime.timedelta(hours=5)
                    }
                ]
            }
        }
