from sandbox import sdk2
from sandbox.projects.runtime_models.releasers import yabs_models_releasers


class SearchHitModelsShard02Layer(sdk2.Resource):
    """
    Layer for search_hit_models_shard02 deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/search_hit_models/shard02_layer.json'


class SearchHitModelsShard03Layer(sdk2.Resource):
    """
    Layer for search_hit_models_shard03 deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/search_hit_models/shard03_layer.json'


class SearchHitModelsMergerLayer(sdk2.Resource):
    """
    Layer for search_hit_models_merger deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/search_hit_models/merger_layer.json'


class RsyaHitModelsLightShard01NannyLayer(sdk2.Resource):
    """
    Layer for nanny:${geo}_yabs_hit_models
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/rsya_hit_models/light_shard01_nanny_layer.json'


class RsyaHitModelsHeavyShard01NannyLayer(sdk2.Resource):
    """
    Layer for nanny:yabs_hit_models_light
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/rsya_hit_models/heavy_shard01_nanny_layer.json'


class CaesarModelsShard01Layer(sdk2.Resource):
    """
    Layer for caesar_models_shard01 deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/banner_shard01_layer.json'


class CaesarModelsShard02Layer(sdk2.Resource):
    """
    Layer for caesar_models_shard02 deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/banner_shard02_layer.json'


class CaesarModelsShard03Layer(sdk2.Resource):
    """
    Layer for caesar_models_shard03 deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/banner_shard03_layer.json'


class CaesarModelsShard04PreprocessingLayer(sdk2.Resource):
    """
    Layer for caesar_models_shard04_preprocessing deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/banner_shard04_preprocessing_layer.json'


class CaesarModelsShard04GpuInferenceLayer(sdk2.Resource):
    """
    Layer for caesar_models_shard04_gpu_inference deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/banner_shard04_gpu_inference_layer.json'


class CaesarModelsSetupLayer(sdk2.Resource):
    """
    Layer for caesar_models_setup deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/setup_layer.json'


class CaesarModelsMergerLayer(sdk2.Resource):
    """
    Layer for caesar_models_merger deploy
    """
    releasable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/packages/caesar_models/merger_layer.json'


class YabsHitModelsDaemon(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'search/daemons/begemot/yabs_hit_models/yabs_hit_models'
    arcadia_build_name = 'yabs_hit_models'


class CaesarModelsDaemon(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'search/daemons/begemot/yabs_caesar_models/yabs_caesar_models'
    arcadia_build_name = 'yabs_caesar_models'


class YabsSearchBannerModelsDaemon(sdk2.Resource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/banner_models/bin/banner_models'
    arcadia_build_name = 'banner_models'


class YabsBegemotEvlogdump(sdk2.resource.AbstractResource):
    """
    begemot event log dumper
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'web/daemons/begemot/event_log_dump/event_log_dump'
    arcadia_build_name = 'event_log_dump'


class YabsModelsServicesBstr(sdk2.Resource):
    """
    bstr executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'tools/bstr/bstr'
    arcadia_build_name = 'bstr'


class YabsModelsServicesBstrCallback(sdk2.Resource):
    """
    models serices bstr callback executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'web/daemons/begemot/scripts/bstr_fresh_deploy/callback/callback'
    arcadia_build_name = 'callback'


class YabsModelsServicesBstrCaller(sdk2.Resource):
    """
    models serices bstr caller executable
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'web/daemons/begemot/scripts/bstr_fresh_deploy/bstr_caller_models_services/bstr_caller'
    arcadia_build_name = 'bstr_caller'


class YabsModelsServicesPoorMansProfiler(sdk2.Resource):
    """
    poor man's profiler binary for yabs models services
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = yabs_models_releasers
    arcadia_build_path = 'yabs/models_services/hit_models/poormansprofiler/poormansprofiler'
    arcadia_build_name = 'poormansprofiler'
