import datetime

from sandbox.projects.runtime_models.BuildBegemotModelsPackageBase import BuildBegemotModelsPackageBase, get_build_models_package_parameters, StorageSources


class BuildZenZephyrItemModelsPackage(BuildBegemotModelsPackageBase):
    class Parameters(BuildBegemotModelsPackageBase.Parameters):
        _bmp = get_build_models_package_parameters(
            rules_to_deploy_default=[],
            bg_shard_default='ZenZephyrItemModels',
            pack_to_tar_default=True,
        )

    @property
    def rule2models(self):
        return {
            'ZenZephyrItemModels': {
                'ZenItemModels': [
                    {
                        'model_name': 'recommender_config',
                        'resource_type': 'ZEN_MODEL_SERVICE_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                                'model_name': 'configs',
                                'model_type': 'item',
                            },
                        },
                        'update_period': datetime.timedelta(days=365),
                    },
                    {
                        'model_name': 'pytorch_dssm_v1',
                        'resource_type': 'ZEN_MODEL_SERVICE_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                                'model_name': 'pytorch_dssm_v1',
                                'model_type': 'item',
                            },
                        },
                        'update_period': datetime.timedelta(days=365),
                    },
                    {
                        'model_name': 'pytorch_transformer_v2',
                        'resource_type': 'ZEN_MODEL_SERVICE_RESOURCE',
                        'source': StorageSources.SANDBOX,
                        'constraints': {
                            'attrs': {
                                'released': 'stable',
                                'model_name': 'pytorch_transformer_v2',
                                'model_type': 'item',
                            },
                        },
                        'update_period': datetime.timedelta(days=365),
                    },
                ],
            }
        }
