def _join_lists_uniq(*args):
    result = []
    used_elements = set()
    for current_list in args:
        for elem in current_list:
            if elem in used_elements:
                continue
            result.append(elem)
            used_elements.add(elem)
    return result


service_owners = [
    "ayles",
    "aleosi",
    "kinan-sarmini",
    "sklevleev",
    "ulyanin",
    "bogdanovilya",
]

robots = [
    "robot-srch-releaser",
    "robot-testenv",
    "robot-tsar-models",
]

caesar_models_releasers = _join_lists_uniq(
    robots,
    service_owners,
    # TODO: replace with bsyeti.common.advanced_releasers
    ["bulatman"],
)

yabs_models_releasers = _join_lists_uniq(
    robots,
    service_owners,
    ["YABS_MODELS_SERVICES"],
)

zen_models_releasers = _join_lists_uniq(
    robots,
    ["robot-zen-dl"],
)
