from sandbox import sdk2
from sandbox.projects.runtime_models.releasers import zen_models_releasers


class WEB_RTMODELS_PLAN(sdk2.Resource):
    """
    Web rtmodels requests plan.
    """
    releasable = True
    any_arch = True


class ZEN_MODEL_SERVICE_RESOURCE(sdk2.Resource):
    """
    Model for Zen Model Service
    """
    releasable = True
    releasers = zen_models_releasers
    any_arch = True
    model_name = sdk2.parameters.String('Model name', required=True)
    # One of ['user', 'item']
    model_type = sdk2.parameters.String('Model type', required=True)
    last_train_table = sdk2.parameters.String('Last train table timestamp', required=False)
