# coding: utf-8

# import time
# import logging

# import sandbox.common.types.task as ctt
import logging
logger = logging.getLogger()

import sandbox.common.types.resource as ctr

from sandbox import sdk2
from sandbox.sandboxsdk.svn import Arcadia
from sandbox.projects.common.nanny import nanny
from sandbox.sdk2.helpers import subprocess

from sandbox.projects.saas.common.resources import SaasRtyserverConfigs

import os
import shutil


class BuildZaasConfigs(nanny.ReleaseToNannyTask2, sdk2.Task):
    """Get configs from svn and release them"""

    class Parameters(sdk2.Task.Parameters):
        arcadia_path = sdk2.parameters.ArcadiaUrl(
            'Arcadia url', required=True, default_value=Arcadia.trunk_url() + '/saas/static_configs/zen/services/zen_item_als_new'
        )

    def add_all_to_resource(self):
        for filename in os.listdir(self.Context.local_configs_path):
            source_filepath = os.path.join(self.Context.local_configs_path, filename)
            if os.path.isfile(source_filepath):
                shutil.copy(source_filepath, self.Context.local_resource_path)
                logger.debug("copy {} to {}".format(source_filepath, self.Context.local_resource_path))
            else:
                logger.debug("{} is not a file. Can't copy it.".format(source_filepath))

    def on_execute(self):
        self.Context.local_configs_path = str(sdk2.svn.Arcadia.get_arcadia_src_dir(self.Parameters.arcadia_path))

        resource = SaasRtyserverConfigs(self, self.Parameters.description, 'configs')
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)
        self.Context.local_resource_path = str(resource_data.path)

        with sdk2.helpers.ProcessLog(self, logger='copy_configs') as pl:
            pl.logger.propagate = 1
            self.add_all_to_resource()
        resource_data.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
