from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
import clear


class ClearLogbrokerYTDelivery(sdk2.Task):
    """ clear logbroker yt-delivery data by TTL """

    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('yandex-yt')]
        cores = 1
        ram = 1024
        disk_space = 1024

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        yt_cluster = sdk2.parameters.String('YT cluster', required=True, default='arnold')
        lb_cluster = sdk2.parameters.String('Logbroker cluster', required=True, default='logbroker')
        ttl = sdk2.parameters.Integer('TTL in days', required=True, default=7)
        dry_run = sdk2.parameters.Bool('dry run', default=False)
        batch_remove = sdk2.parameters.Bool('batch remove', default=True)

        yt_token_vault_name = sdk2.parameters.String('YT token vault name', required=True, default='YT_TOKEN_ARNOLD')
        yt_token_vault_owner = sdk2.parameters.String('YT token vault owner')

    def on_execute(self):
        yt_token_vault_owner = self.owner
        if self.Parameters.yt_token_vault_owner:
            yt_token_vault_owner = self.Parameters.yt_token_vault_owner
        yt_token = sdk2.Vault.data(
            yt_token_vault_owner,
            self.Parameters.yt_token_vault_name
        )

        cleaner = clear.Cleaner(
            yt_cluster=self.Parameters.yt_cluster,
            yt_token=yt_token,
            dry_run=self.Parameters.dry_run,
            batch_execute=self.Parameters.batch_remove
        )
        cleaner.run(self.Parameters.lb_cluster, self.Parameters.ttl)
