# -*- coding: utf-8 -*-

import json
import logging
import os

from sandbox import sdk2
from sandbox.projects import resource_types
# from sandbox.projects.saas.common.resources import SaasInstanceList
from sandbox.projects.common.arcadia import sdk as arcadiasdk


class ExtractGencfgShard(sdk2.Task):
    class Parameters(sdk2.Parameters):
        intlookup_name = sdk2.parameters.String('Intlookup name', required=True)
        shard_index = sdk2.parameters.Integer('Shard index', required=True)

    def on_execute(self):
        logging.info('Starting...')
        slots = None
        with arcadiasdk.mount_arc_path('svn+ssh://arcadia.yandex.ru/arc/trunk/data/gencfg_db/intlookups') as intlookup_dir:
            intlookup_path = os.path.join(intlookup_dir, self.Parameters.intlookup_name)
            logging.info('Read intlookup file {}'.format(intlookup_path))
            with open(intlookup_path, 'r') as intlookup_file:
                slots = parse_intlookup(intlookup_file.read(), self.Parameters.shard_index)
                logging.info('Extracted slots:\n{}'.format('\n'.join(slots)))

        slots_name = '{}_{}'.format(self.Parameters.intlookup_name, self.Parameters.shard_index)
        logging.info('Create resource {}'.format(slots_name))
        # slots_resource = SaasInstanceList(
        slots_resource = resource_types.OTHER_RESOURCE(
            self,
            'Intlookup slots',
            path=str(self.path(slots_name)),
            intlookup_name=self.Parameters.intlookup_name,
            shard_index=self.Parameters.shard_index
        )
        slots_resource_data = sdk2.ResourceData(slots_resource)
        with open(str(slots_resource_data.path), 'w') as slots_file:
            slots_file.write('\n'.join(slots))
        slots_resource_data.ready()
        logging.info('Finished.')


def parse_intlookup(json_str, shard_index):
    slots = []
    intlookup = json.loads(json_str)
    if shard_index + 1 >= len(intlookup[1]):
        return slots
    for instance in intlookup[1][shard_index + 1]:
        slot = ':'.join(instance[2][0].split(':')[:2])
        slots.append(slot)
    return slots
