# -*- coding: utf-8 -*-

from sandbox import sdk2

from sandbox.projects.common.nanny import nanny

from sandbox.projects.saas.common.resources import SaasRtyserverConfigs


class BuildGeminiRtyserverConfigs(sdk2.Task, nanny.ReleaseToNannyTask2):

    class Requirements(sdk2.Requirements):
        pass

    class Parameters(sdk2.Parameters):
        arcadia_configs_path = sdk2.parameters.ArcadiaUrl(
            'Path to gemini rtyserver configs',
            required=True,
            default_value='arcadia:/arc/trunk/arcadia/saas/static_configs/gemini/rtyserver_configs'
        )

    def on_execute(self):
        resource = sdk2.ResourceData(SaasRtyserverConfigs(self, 'rtyserver configs', 'rtyserver_configs'))
        sdk2.svn.Arcadia.export(self.Parameters.arcadia_configs_path, str(resource.path))
        resource.ready()
