# coding: utf-8

import datetime

import sandbox.sdk2 as sdk2

from sandbox.projects.common.nanny import nanny
from sandbox.projects.saas.common.classes import SaasBinaryTask
from sandbox.projects.saas.common.resources import SaasShardMap, SaasShardMapYp, SaasShardMapGencfg


class RenderSaasShardmap(nanny.ReleaseToNannyTask2, SaasBinaryTask):
    """Generate shardmap resource for saas service"""
    TASKS_RESOURCE_NAME = 'SaasShardmapTasks'

    class Parameters(sdk2.Task.Parameters):
        ctype = sdk2.parameters.String('SaaS ctype', required=True, hint=True)
        service = sdk2.parameters.String('SaaS service name', required=True, hint=True)
        with sdk2.parameters.Group('Shard data') as shard_data_params:
            with sdk2.parameters.RadioGroup('Cluster') as yt_cluster:
                yt_cluster.values.hahn = yt_cluster.Value(value='hahn', default=True)
                yt_cluster.values.arnold = yt_cluster.Value(value='arnold')
            shards_data = sdk2.parameters.String('Standalone indexer result path', required=False)
        with sdk2.parameters.Group('Authorisation') as authorisation:
            nanny_secret_id = sdk2.parameters.String('YAV secret id with Nanny token', default_value='sec-01d7yrs98p2h9jns5zq59evyeh')
            nanny_secret_key = sdk2.parameters.String('YAV secret key for Nanny', default_value='saas-robot-nanny-token')
            yt_secret_id = sdk2.parameters.String('YAV secret id with YT token', default_value='sec-01d74p6hkcabgfq4cv38mqyn9k')
            yt_secret_key = sdk2.parameters.String('YAV secret key for YT', default_value='yt_token')

    def on_execute(self):
        from saas.library.python.token_store import TokenStore
        from saas.library.python.deploy_manager_api.saas_service import SaasService
        from saas.library.python import shardmap
        nanny_secret = sdk2.yav.Secret(self.Parameters.nanny_secret_id)
        TokenStore.add_token('nanny', nanny_secret.data()[self.Parameters.nanny_secret_key])

        self.Context.dm_shardmap = SaasService(self.Parameters.ctype, self.Parameters.service).slots_by_interval

        date_str = datetime.date.today().isoformat()
        shards_data = shardmap.build_shards_data(self.Parameters.yt_cluster, self.Parameters.shards_data, self.Parameters.yt_secret_id, self.Parameters.yt_secret_key) if self.Parameters.shards_data else None
        yp_shardmap, gencfg_shardmap = shardmap.build_shardmap(self.Parameters.service, self.Context.dm_shardmap, shards_data)
        if yp_shardmap:
            shard_filename = '{}_{}_{}_yp.map'.format(self.Parameters.ctype, self.Parameters.service, date_str)
            resource = sdk2.ResourceData(SaasShardMapYp(
                self, 'SaasShardMapYp', shard_filename, ttl=360,
                saas_ctype=self.Parameters.ctype, saas_service=self.Parameters.service
            ))
            with open(str(resource.path), 'w') as f:
                f.writelines(yp_shardmap)
            resource.ready()
        if gencfg_shardmap:
            shard_filename = '{}_{}_{}_gencfg.map'.format(self.Parameters.ctype, self.Parameters.service, date_str)
            resource = sdk2.ResourceData(SaasShardMapGencfg(
                self, 'SaasShardMapGencfg', shard_filename, ttl=360,
                saas_ctype=self.Parameters.ctype, saas_service=self.Parameters.service
            ))
            with open(str(resource.path), 'w') as f:
                f.writelines(gencfg_shardmap)
            resource.ready()

        if gencfg_shardmap or yp_shardmap and not (gencfg_shardmap and yp_shardmap):
            shard_filename = '{}_{}_{}.map'.format(self.Parameters.ctype, self.Parameters.service, date_str)
            resource = sdk2.ResourceData(SaasShardMap(
                self, 'SaasShardMap', shard_filename, ttl=360,
                saas_ctype=self.Parameters.ctype, saas_service=self.Parameters.service
            ))
            single_shard = gencfg_shardmap if gencfg_shardmap else yp_shardmap
            with open(str(resource.path), 'w') as f:
                f.writelines(single_shard)
            resource.ready()

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask2.on_release(self, additional_parameters)
        sdk2.Task.on_release(self, additional_parameters)
