# coding: utf-8

import sandbox.sdk2 as sdk2
from sandbox.projects.saas.common.classes import SaasBinaryTask


class StoreShootingMetrics(SaasBinaryTask):

    """Load test SaaS service"""
    TASKS_RESOURCE_NAME = 'SaasLoadTestTasks'

    class Parameters(sdk2.Task.Parameters):
        shooting_task_id = sdk2.parameters.String('Shooting task id', required=True)

        with sdk2.parameters.Group('Authorization') as authorization:
            yt_secret_id = sdk2.parameters.String(
                'YAV secret id with YT token', default_value='sec-01d74p6hkcabgfq4cv38mqyn9k')
            yt_secret_key = sdk2.parameters.String(
                'YAV secret key for YT', default_value='yt_token')

    def on_execute(self):
        from sandbox.projects.saas.common.shooting import ShootingResults

        yt_secret = sdk2.yav.Secret(self.Parameters.yt_secret_id)
        yt_token = yt_secret.data()[self.Parameters.yt_secret_key]

        ShootingResults.init_yt_client(yt_token)
        m = sdk2.Task[self.Parameters.shooting_task_id].Context.final_measurements
        ShootingResults.fromdict(m).store_metrics()
