# coding: utf-8

from __future__ import absolute_import
from __future__ import division
from __future__ import unicode_literals

import logging
import requests
import sandbox.sdk2 as sdk2


from six.moves.urllib_parse import urljoin

from sandbox.common.errors import TaskError
from sandbox.common.types import task as ctt


class DmProxyHandles(object):
    def __init__(self):
        self.session = requests.Session()
        self.base_url = 'https://saas-dm-proxy.n.yandex-team.ru'

    def get_dm_shardmap(self, ctype, service):
        request_url = urljoin(self.base_url, '/api/slots_by_interval/')
        return self.session.get(request_url, params={'ctype': ctype, 'service': service}).json()

    def get_nanny_services(self, ctype, service):
        request_url = urljoin(self.base_url, '/tags_info')
        nanny_services = [
            ns.split('@')[0]
            for ns
            in self.session.get(request_url, params={'ctype': ctype, 'service': service}).json().get('nanny_services', [])
        ]
        return nanny_services

    def get_searchproxy_nanny_service(self, ctype):
        nanny_services = self.get_nanny_services(ctype, 'searchproxy')
        if not nanny_services:
            raise RuntimeError('Got no Nanny services for {} searchproxy'.format(ctype))
        elif len(nanny_services) == 1:
            return nanny_services[0]
        else:
            man_services = [service for service in nanny_services if 'man' in service]
            if man_services:
                return man_services[0]
            else:
                logging.warning('No MAN searchproxy services detected in %s, trying to choose YP', nanny_services)
                yp_services = [service for service in nanny_services if 'yp' in service]
                if yp_services:
                    return yp_services[0]
                else:
                    logging.error('No YP searchproxy detected in %s, fallback to first service', nanny_services)
                    return nanny_services[0]

    def get_sla_rps(self, ctype, service):
        request_url = urljoin(self.base_url, '/process_sla_description')
        sla_dict = self.session.get(request_url, params={'ctype': ctype, 'service': service}).json()
        sla_rps = sla_dict.get('search_rps', 0) or sla_dict.get('search_rps_planned', 0)
        if not sla_rps:
            raise RuntimeError('SLA RPS for service {}@{} not set'.format(service, ctype))
        else:
            return int(sla_rps)


class SaasBinaryTask(sdk2.Task):
    TASKS_RESOURCE_NAME = None
    TASKS_RESOURCE_OWNER = None

    def on_enqueue(self):
        assert self.TASKS_RESOURCE_NAME, "Please define TASKS_RESOURCE_NAME if relying on SaasBinaryTask"
        if not self.Requirements.tasks_resource:
            query = {
                'attrs': {
                    'released': ctt.ReleaseStatus.STABLE,
                    'name': self.TASKS_RESOURCE_NAME,
                },
            }
            if self.TASKS_RESOURCE_OWNER:
                query.update({'owner': self.TASKS_RESOURCE_OWNER})
            self.Requirements.tasks_resource = sdk2.service_resources.SandboxTasksBinary.find(**query).first()
            if not self.Requirements.tasks_resource:
                raise TaskError('Binary task resource is not found')
