import datetime
from sandbox import sdk2

from sandbox.projects.resource_types import resource_releasers
from sandbox.projects.porto.common.resource_types import PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP, PORTO_LAYER_SEARCH_UBUNTU_FOCAL_APP
from sandbox.projects.ydo.resource_types import ydo_releasers
from sandbox.projects.mediasearch.resource_types import mediasearch_releasers


class RTYSERVER_LOOP_CONF(sdk2.Resource):
    """
        RTYServer loop conf
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class RTYSERVER_LOOP_CONF_YP(sdk2.Resource):
    """
        RTYServer loop conf for yp
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class RTYSERVER_LOOP_DATA(sdk2.Resource):
    """
        RTYServer iss loop data
    """
    auto_backup = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasRtyserverConfigs(sdk2.Resource):
    """
        SAAS rtyserver configs
    """
    releasable = True
    releasers = resource_releasers.saas_releasers
    auto_backup = True


class SaasRtyserverConfigsBundle(sdk2.Resource):
    """
        SAAS rtyserver configs for refresh
    """
    releasable = True
    releasers = resource_releasers.saas_releasers
    auto_backup = True


class SaasSearchproxyConfigs(sdk2.Resource):
    """
        SAAS searchproxy configs
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class FerrymanConfig(sdk2.Resource):
    """
        Ferryman config
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    releasers = resource_releasers.saas_releasers
    service = sdk2.Attributes.String("Service name", required=True)


class YconfPatcher(sdk2.Resource):
    """
        Config patcher for yconf format
    """
    releasable = True
    executable = True
    auto_backup = True
    ttl = 'inf'


class SaaSHostsInfo(sdk2.Resource):
    """Deprecated host info format for old allocation mechanics"""


class SaasHostsInfoFull(sdk2.Resource):
    """Gencfg hosts and instances info in json format"""
    date = sdk2.Attributes.String("Collection date in ISO format", required=True, default=datetime.date.today().isoformat())


class SAAS_UTIL_STANDALONE_INDEXER(sdk2.resource.AbstractResource):
    """
        SAAS standalone indexer binary
    """
    releasable = True
    any_arch = False
    executable = True
    arcadia_build_path = 'saas/tools/standalone_indexer/standalone_indexer'
    arcadia_build_name = 'standalone_indexer'


class SAAS_UTIL_GET_STANDALONE_INDEXER(sdk2.resource.AbstractResource):
    """
        SAAS utility to get standalone indexer binary and service configs
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True


class RTYSERVER_TEST_TAR_GZ(sdk2.Resource):
    """
        RTYServer related resource
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True


class SaasPushClient(sdk2.Resource):
    """
        SAAS push utility to write to the logbroker
    """
    releasable = True
    releasers = resource_releasers.saas_releasers
    auto_backup = True


class SaasSearchMap(sdk2.Resource):
    """
        SAAS SearchMap
    """
    releasable = True
    releasers = resource_releasers.saas_releasers
    auto_backup = True


class SaasShardMap(sdk2.Resource):
    """
        Shardmap for SaaS service
    """
    auto_backup = True
    releasable = True
    releasers = (
        resource_releasers.saas_releasers
        + [
            'robot-mlmarines', 'robot-video-recom', 'robot-favicon', 'robot-shinydiscovery', 'robot-entityrecom', 'robot-answers',
            'robot-collections', 'robot-adv-machine', 'MARKET_RECOM',
            'robot-mlp-morpheus', 'GOODS_RECOMMENDER'
        ]
        + ydo_releasers
        + mediasearch_releasers
    )


class SaasShardMapYp(SaasShardMap):
    """
        Shardmap for SaaS service in YP
    """


class SaasShardMapGencfg(SaasShardMap):
    """
        Shardmap for SaaS service in Gencfg
    """


class SaasTankAmmo(sdk2.Resource):
    """
        Ammofile from SaaS logs
    """
    releasable = False
    executable = False


class SaasInstanceList(sdk2.Resource):
    """
        Text file with GenCfg slots
    """
    intlookup_name = sdk2.Attributes.String("Intlookup name", required=True)
    shard_index = sdk2.Attributes.Integer("Shard index", required=True)


class RefreshIndexerBinary(sdk2.Resource):
    """
        refresh_indexer binary
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.base_releasers + resource_releasers.saas_releasers


class SaasCanaryReader(sdk2.Resource):
    """
        Canary testing: reader binary
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasCanaryWriter(sdk2.Resource):
    """
        Canary testing: writer binary
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasLbDcChecker(sdk2.Resource):
    """
        Logbroker datacenter checker binary
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasFban(sdk2.Resource):
    """
        New FBAN binary
    """
    auto_backup = True
    executable = True
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasFbanSettings(sdk2.Resource):
    """
        FBAN settings.yaml
    """
    auto_backup = True
    executable = False
    releasable = True
    releasers = resource_releasers.saas_releasers


class SaasSsmPackage(sdk2.Resource):
    """
        SAAS SSM package
    """
    releasable = True
    releasers = resource_releasers.saas_releasers + ['robot-srch-releaser']
    auto_backup = True


class PORTO_LAYER_SAAS_UBUNTU_FOCAL_APP_DIFF(PORTO_LAYER_SEARCH_UBUNTU_FOCAL_APP):
    """
    Portolayer diff with custom SaaS packages. Build on top of PORTO_LAYER_SEARCH_UBUNTU_FOCAL_APP
    """
    releasers = resource_releasers.saas_releasers


class PORTO_LAYER_SAAS_UBUNTU_BIONIC_APP_DIFF(PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP):
    """
    Portolayer diff with custom SaaS packages. Build on top of PORTO_LAYER_SEARCH_UBUNTU_BIONIC_APP
    """
    releasers = resource_releasers.saas_releasers

class RTYSERVER_C(sdk2.Resource):
    """
    RTYServer with C allocator
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.saas_releasers

class RTYSERVER_HU(sdk2.Resource):
    """
    RTYServer with HU allocator
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = resource_releasers.saas_releasers
