from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment


class SaasMetricsCalculation(sdk2.Task):
    """ SaaS metrics calculation. """

    class Requirements(sdk2.Task.Requirements):
        environments = [
            PipEnvironment('python-statface-client',  '0.81.0'),
            PipEnvironment('yasmapi')
        ]

    class Parameters(sdk2.Parameters):
        config = sdk2.parameters.JSON('Metrics config', required=True)
        token_from_vault = sdk2.parameters.Bool("Get OAuth token from vault", default=False)
        with token_from_vault.value[True]:
            vault_token_owner = sdk2.parameters.String("Vault token owner")
            vault_token_name = sdk2.parameters.String("Vault token name")

    def on_execute(self):
        from metrics import SaaSMetrics

        config = self.Parameters.config
        if self.Parameters.token_from_vault:
            statistica_config = config.get('statistica', {})
            statistica_config['token'] = sdk2.Vault.data(
                self.Parameters.vault_token_owner,
                self.Parameters.vault_token_name
            )
            config['statistica'] = statistica_config

        SaaSMetrics(config=config).calculate()
