class Config(object):
    SANDBOX_OWNER = 'ANTISPAM-ROBOT'
    DOCKER_USER_NAME = 'robot-antispam'
    DOCKER_TOKEN_VAULT_NAME = 'docker-oauth-token'
    QLOUD_TOKEN_VAULT_NAME = 'qloud-oauth-token'
    YT_TOKEN_VAULT_OWNER = 'ANTISPAM-ROBOT'
    YT_TOKEN_VAULT_NAME = 'yt-token'
    DOCKER_REPOSITORY = 'yweb/antispam/clean_web'
    CLEAN_WEB_ROOT = 'yweb/antispam/clean_web'
    ENVIRONMENT_PREFIX = 'safesearch'

    CLEAN_WEB_TESTS = []


class CleanWebProject:
    def __init__(self, title=None, environment_id=None, service=None, components=None):
        self.title = title
        self.environment_id = environment_id
        self.service = service
        self.components = components


class CleanWebProjectComponent:
    def __init__(self, component_name=None, path=None):
        self.component_name = component_name
        self.path = path


def default_components(project_name, components=None):
    components = components or ['rpc', 'master', 'worker']
    result = []
    for component in components:
        path = '{}/{}'.format(project_name, component.replace('-', '_'))
        result.append(CleanWebProjectComponent(component, path))
    return result


PROJECTS = [
    CleanWebProject(title='Answers',
                    environment_id='answers-antispam-route',
                    service='answers',
                    components=default_components('clients/answers', ['rpc'])),

    CleanWebProject(title='Beru',
                    environment_id='beru-antispam',
                    components=default_components('clients/beru', ['rpc'])),

    CleanWebProject(title='Clean-web user-karma',
                    environment_id='clean-web-user-karma',
                    components=default_components('user_karma', ['lb-reader']) + [
                        CleanWebProjectComponent('rpc-v2', 'user_karma/rpc'),
                    ]),

    CleanWebProject(title='Messenger lb-reader',
                    environment_id='messenger-lb-reader',
                    components=default_components('messenger/lb_reader', ['message-lb-reader'])),

    CleanWebProject(title='Clean-web router',
                    environment_id='clean-web-router',
                    service='mssngr:ether',
                    components=[
                        CleanWebProjectComponent('router', 'router/rpc'),
                        CleanWebProjectComponent('router-v2', 'router/rpc_v2'),
                        CleanWebProjectComponent('deferred_sender', 'router/deferred_sender'),
                        CleanWebProjectComponent('lb_reader', 'router/lb_reader'),
                        CleanWebProjectComponent('master', 'router/master'),
                        CleanWebProjectComponent('worker', 'router/worker'),
                        CleanWebProjectComponent('deferred-pq-router', 'router/deferred_pq_router'),
                        CleanWebProjectComponent('pq-router', 'router/pq_router'),
                    ]),

    CleanWebProject(title='Collections',
                    environment_id='collections-antispam',
                    service='collections',
                    components=default_components('clients/collections')),

    CleanWebProject(title='Fast-only',
                    environment_id='fast-only',
                    service='toloka_pd_check',
                    components=default_components('backends/fast_only', ['rpc'])),

    CleanWebProject(title='Messenger Channels',
                    environment_id='channels-antispam',
                    service='mssngr:channels',
                    components=default_components('messenger/clients/channels', ['rpc'])),

    CleanWebProject(title='Messenger Common',
                    environment_id='messenger-common',
                    components=default_components('messenger/clients/messenger_common', ['rpc'])),

    CleanWebProject(title='Messenger Private',
                    environment_id='messenger-private',
                    service='mssngr:collections',
                    components=default_components('messenger/private_messages', ['rpc'])),

    CleanWebProject(title='Kinopoisk',
                    environment_id='kinopoisk-antispam',
                    service='kinopoisk',
                    components=default_components('clients/kinopoisk', ['rpc'])),

    CleanWebProject(title='Map Talks',
                    environment_id='map-talks',
                    service='map_talks',
                    components=default_components('clients/map_talks', ['rpc'])),

    CleanWebProject(title='Market',
                    environment_id='market-antispam',
                    service='market',
                    components=default_components('clients/market', ['rpc'])),

    CleanWebProject(title='Market QA',
                    environment_id='market-qa',
                    service='market-qa',
                    components=default_components('clients/market_qa', ['rpc'])),

    CleanWebProject(title='Offline-only',
                    environment_id='offline-only',
                    service='geosmb',
                    components=default_components('backends/offline_only', ['rpc'])),

    CleanWebProject(title='Passport',
                    environment_id='passport-antispam',
                    service='passport',
                    components=default_components('clients/passport', ['rpc'])),

    CleanWebProject(title='Synchronous',
                    environment_id='synchronous-antispam',
                    service='synchronous',
                    components=default_components('clients/synchronous', ['rpc'])),

    CleanWebProject(title='Talk',
                    environment_id='talk-antispam',
                    components=default_components('clients/talk', ['rpc'])),

    CleanWebProject(title='Tutor',
                    environment_id='tutor-antispam',
                    service='tutor',
                    components=default_components('clients/tutor', ['rpc'])),

    CleanWebProject(title='Tycoon',
                    environment_id='tycoon-antispam',
                    components=default_components('clients/tycoon')),

    CleanWebProject(title='Ugc',
                    environment_id='ugc-antispam',
                    components=default_components('clients/ugc')),

    CleanWebProject(title='Uslugi',
                    environment_id='uslugi-antispam',
                    components=default_components('clients/uslugi', ['offline', 'rpc'])),

    CleanWebProject(title='Videohosting',
                    environment_id='videohosting-antispam',
                    service='videohosting',
                    components=default_components('clients/videohosting', ['rpc'])),

    CleanWebProject(title='Media checker without OCR',
                    environment_id='media-checker-without-ocr',
                    components=[CleanWebProjectComponent('service', 'media_checker/docker/without_ocr')]),

    CleanWebProject(title='Media checker with OCR',
                    environment_id='media-checker-with-ocr',
                    components=[CleanWebProjectComponent('service', 'media_checker/docker/with_ocr')]),

    CleanWebProject(title='Bert Toxicity',
                    environment_id='bert',
                    components=[CleanWebProjectComponent('toxicity', 'bert/docker/toxicity')]),

    CleanWebProject(title='Bert Constructivity',
                    environment_id='bert',
                    components=[CleanWebProjectComponent('constructivity', 'bert/docker/constructivity')]),

    CleanWebProject(title='Bert Common Toloka',
                    environment_id='bert',
                    components=[CleanWebProjectComponent('bert_common_toloka', 'bert/docker/common_toloka')]),

    CleanWebProject(title='Toloka',
                    environment_id='toloka-antispam',
                    components=default_components('toloka', ['lb-reader', 'rpc', 'sender', 'waiter', 'worker'])),
]
