import tarfile

from sandbox import sdk2
from sandbox.projects.common.ya_deploy import release_integration
from sandbox.projects.safesearch.MetrikaSafesearchData import resource_types as rtdsd
from sandbox.projects.safesearch.ReleaseTries import resource_types as rt


class ReleaseTries(sdk2.Task, release_integration.ReleaseToNannyAndYaDeployTask2):

    class Parameters(sdk2.Task.Parameters):
        description = 'testing'
        release_type = "testing"

    def on_execute(self):
        from_res = sdk2.Resource.find(type=rtdsd.MetrikaSafesearchData).first()
        from_res_data = sdk2.ResourceData(from_res)

        new_res = rt.KoTestResourse(
            self,
            description="KoTest. Created by Sandbox task #{}".format(self.id),
            path="testtrie.gzip",
        )
        new_res_data = sdk2.ResourceData(new_res)

        #  shutil.copy(str(from_res_data.path), str(new_res_data.path))

        with tarfile.open(str(new_res_data.path), 'w:gz') as arch:
            arch.add(str(from_res_data.path))

        new_res_data.ready()

    def on_release(self, parameters_):
        release_integration.ReleaseToNannyAndYaDeployTask2.on_release(self, parameters_)
        sdk2.Task.on_release(self, parameters_)
        self.mark_released_resources(parameters_["release_status"], ttl=9)
