# coding: utf-8

import logging
import sandbox.projects.samovar as samovar_resources

from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.projects.samovar.common.base_bin_build import BaseBuildSamovarBins
from sandbox.projects.samovar.common.base_bin_build import SamovarBinaries
from sandbox.projects.samovar.common.base_bin_build import init


class BuildQualityPackage(BaseBuildSamovarBins):
    '''
        Binaries, configs and scripts for Quality.
    '''

    type = 'BUILD_ROBOT_QUALITY_PACKAGE'

    class IncludeSvnScripts(parameters.SandboxBoolParameter):
        name = 'include_svn_scripts'
        description = 'scripts'
        default_value = True
        group = 'Quality Files'

    class IncludeComplianceSamples(parameters.SandboxBoolParameter):
        name = 'include_compliance_samples'
        description = 'compliance samples'
        default_value = True
        group = 'Quality Files'

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_STABLE)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
        samovar_resources.SAMOVAR_COMPLIANCE_CHECKER,
        samovar_resources.SAMOVAR_COMPLIANCE_TOOL,
        samovar_resources.SAMOVAR_CRAWL_STAT,
        samovar_resources.SAMOVAR_FEED_DUMP_CUTTER,
        samovar_resources.SAMOVAR_TABLE_SAMPLER,
        samovar_resources.SAMOVAR_FEATURES_PRODUCE_SHOWS,
        samovar_resources.SAMOVAR_FEATURES_PRODUCE_CRAWLS,
        samovar_resources.SAMOVAR_MERGE_SAMOVAR_SENDLINK_DUMP_DELTAS,
        samovar_resources.SAMOVAR_MERGE_SAMOVAR_DUMPS_DELTAS_TO_DAILY,
        samovar_resources.SAMOVAR_ROTOR_RANK_COLLECT_HOST_COUNTERS,
        samovar_resources.SAMOVAR_USERDATA_FACTORS,
        samovar_resources.SAMOVAR_SNIPPETS_MERGER_NEW,
        samovar_resources.SAMOVAR_HOSTDATA_EXPORT,
        samovar_resources.SAMOVAR_QUALITY_FULL_EDR
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [SamovarBinaries])
    input_parameters = input_parameters + [
                                           IncludeSvnScripts,
                                           IncludeComplianceSamples,
                                           ReleaseToNanny
                                          ]

    def on_execute(self):
        BaseBuildSamovarBins.on_execute(self)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Quality binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildSamovarBins.post_build(self, source_dir, output_dir, pack_dir)
        if self.ctx['include_svn_scripts']:
            self._create_svn_resource('robot/lemur/scripts', 'quality_scripts.tar.gz', samovar_resources.SAMOVAR_QUALITY_SVN_SCRIPTS, source_dir)
        if self.ctx['include_compliance_samples']:
            self._create_svn_resource('robot/compliance_samples', 'compliance_samples.tar.gz', samovar_resources.SAMOVAR_COMPLIANCE_SAMPLES, source_dir)


__Task__ = BuildQualityPackage
