# coding: utf-8

import os

import logging
import sandbox.projects.samovar as samovar_resources

from sandbox import sdk2
from sandbox.sandboxsdk import sandboxapi
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.samovar.common.base_bin_build import BaseBuildSamovarBins
from sandbox.projects.samovar.common.base_bin_build import SamovarBinaries
from sandbox.projects.samovar.common.base_bin_build import init

import sandbox.projects.common.constants as consts

class BuildSamovarTestPackage(BaseBuildSamovarBins):
    '''
    Binaries, configs and scripts for samovar.
    '''

    type = 'BUILD_SAMOVAR_TEST_PACKAGE'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 60 * 1024

    class IncludeSvnConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_configs'
        description = 'configs'
        default_value = True
        group = 'Samovar Files'

    class IncludeSvnScripts(parameters.SandboxBoolParameter):
        name = 'include_svn_scripts'
        description = 'scripts'
        default_value = True
        group = 'Samovar Files'

    class IncludeSvnGageboardFrontend(parameters.SandboxBoolParameter):
        name = 'include_svn_gageboard_frontend'
        description = 'gageboard frontend'
        default_value = True
        group = 'Samovar Gageboard frontend files'

    class IncludeSvnModels(parameters.SandboxBoolParameter):
        name = 'include_svn_models'
        description = 'models'
        default_value = True
        group = 'Samovar Models'

    class ReleaseToNanny(parameters.SandboxRadioParameter):
        choices = [(_, _) for _ in ('none', sandboxapi.RELEASE_TESTING)]
        description = "Release to Nanny."
        default_value = 'none'
        name = 'release_to_nanny'
        group = 'After Build Actions'

    TARGET_RESOURCES = (
        samovar_resources.SAMOVAR_COMBUSTOR,
        samovar_resources.SAMOVAR_TENDER,
        samovar_resources.SAMOVAR_BOILER,
        samovar_resources.SAMOVAR_GAGEBOARD,
        samovar_resources.SAMOVAR_GLOBAL_COUNTERS_TOOL,
        samovar_resources.SAMOVAR_SALMON_AGENT,
        samovar_resources.SAMOVAR_CREATE_INSTANCE,
        samovar_resources.SAMOVAR_PUSH_MONSTER_HOSTS_MERGER,
        samovar_resources.SAMOVAR_RENEWED,
        samovar_resources.SAMOVAR_PUSH_WRITER,
        samovar_resources.SAMOVAR_RECORD_REMOVER,
        samovar_resources.SAMOVAR_GEN_OWNER2HOST_MAP,
        samovar_resources.SAMOVAR_LOG2YT,
        samovar_resources.SAMOVAR_COUNTERS_TOOL,
        samovar_resources.SAMOVAR_EXPORT_PRIMARY_HOST_DATA,
        samovar_resources.SAMOVAR_EXPORT_PROCESSOR,
        samovar_resources.SAMOVAR_EXPORT_LB_WRITER,
        samovar_resources.SAMOVAR_PREPARE_WATCH_LOG_WHITE_COUNTERS,
        samovar_resources.SAMOVAR_LIMITS_TESTER,
        samovar_resources.SAMOVAR_TOPS_MONITOR,
        samovar_resources.SAMOVAR_EJECTOR,
        samovar_resources.SAMOVAR_QUEUE_ANALYZER,
        samovar_resources.SAMOVAR_TABLETS_MONITOR,
        samovar_resources.SAMOVAR_TABLE_BALANCER,
        samovar_resources.SAMOVAR_URL_REDUCE_DURATION_CALC,
        samovar_resources.SAMOVAR_DIRECT_DATA,
        samovar_resources.SAMOVAR_QUEUE_PROCESSOR,
        samovar_resources.SAMOVAR_SMALL_URL_DATA_TABLE_MERGER,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [SamovarBinaries])
    input_parameters = input_parameters + [IncludeSvnConfigs,
                                           IncludeSvnScripts,
                                           IncludeSvnGageboardFrontend,
                                           IncludeSvnModels,
                                           ReleaseToNanny
                                          ]

    def initCtx(self):
        BaseBuildSamovarBins.initCtx(self)
        self.ctx['clear_build'] = False

    def on_execute(self):
        self.ctx['ya_yt_token_vault_owner'] = 'UKROP-ROBOT'
        self.ctx['ya_yt_token_vault_name'] = 'sandbox-build-yt-token'

        BaseBuildSamovarBins.on_execute(self)

        if self.ctx['release_to_nanny'] != 'none':

            check_already_released = False

            releaser_task = self.create_subtask(
                task_type='RELEASE_ANY',
                input_parameters={
                    'check_already_released': check_already_released,
                    'release_task_id': self.id,
                    'release_status': self.ctx['release_to_nanny'],
                },
                description="Samovar binaries (task id: {}) auto release. Revision: {}".format(str(self.id), self.ctx.get('arcadia_revision'))
            )
            logging.debug("Subtask {} runned, waiting for it's result.\n\n".format(releaser_task.id))

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildSamovarBins.post_build(self, source_dir, output_dir, pack_dir)

        if self.ctx['include_svn_configs']:
            self._create_svn_resource('robot/samovar/conf', 'svn_configs.tar.gz', samovar_resources.SAMOVAR_SVN_CONFIGS, source_dir)

        if self.ctx['include_svn_scripts']:
            self._create_svn_resource('robot/samovar/scripts', 'scripts.tar.gz', samovar_resources.SAMOVAR_SVN_SCRIPTS, source_dir)

        if self.ctx['include_svn_gageboard_frontend']:
            self._create_svn_resource('robot/samovar/gageboard/frontend', 'gageboard_frontend.tar.gz', samovar_resources.SAMOVAR_GAGEBOARD_FRONTEND, source_dir)

        if self.ctx['include_svn_models']:
            self._create_svn_resource('robot/samovar/models', 'models.tar.gz', samovar_resources.SAMOVAR_SVN_MODELS, source_dir)




__Task__ = BuildSamovarTestPackage
