# coding: utf-8

import sandbox.projects.samovar as samovar_resources

from sandbox import sdk2
from sandbox.sandboxsdk import parameters
from sandbox.projects.samovar.common.base_bin_build import BaseBuildSamovarBins
from sandbox.projects.samovar.common.base_bin_build import SamovarBinaries
from sandbox.projects.samovar.common.base_bin_build import init


class BuildSamovarUzorPackage(BaseBuildSamovarBins):
    '''
    Binaries and configs for samovar's uzor.
    '''

    type = 'BUILD_SAMOVAR_UZOR_PACKAGE'

    class Requirements(sdk2.Task.Requirements):
        disk_space = 40 * 1024

    class SamovarConfigsExternal(parameters.SandboxBoolParameter):
        name = 'include_svn_samovar_configs'
        description = 'samovar configs'
        default_value = True
        group = 'Samovar uzor Files'

    class UzorConfigs(parameters.SandboxBoolParameter):
        name = 'include_svn_uzor_configs'
        description = 'uzor configs'
        default_value = True
        group = 'Samovar uzor Files'

    TARGET_RESOURCES = (
        samovar_resources.SAMOVAR_UZOR,
    )

    input_parameters, enabled_builds = init(TARGET_RESOURCES, [SamovarBinaries])
    input_parameters = input_parameters + [SamovarConfigsExternal, UzorConfigs]

    def post_build(self, source_dir, output_dir, pack_dir):
        BaseBuildSamovarBins.post_build(self, source_dir, output_dir, pack_dir)
        if self.ctx['include_svn_samovar_configs']:
            self._create_svn_resource('robot/samovar/conf', 'svn_configs.tar.gz', samovar_resources.SAMOVAR_SVN_CONFIGS, source_dir)
        if self.ctx['include_svn_uzor_configs']:
            self._create_svn_resource('robot/uzor/conf', 'svn_uzor_configs.tar.gz', samovar_resources.SAMOVAR_UZOR_SVN_CONFIGS, source_dir)



__Task__ = BuildSamovarUzorPackage
