# coding: utf-8

from sandbox.sandboxsdk import parameters

from sandbox.projects.common.nanny import nanny
from sandbox.projects.common.build import YaPackage
from sandbox.projects import resource_types


class BuildSamovarUzorSvnPackage(YaPackage.YaPackage, nanny.ReleaseToNannyTask):

    type = 'BUILD_SAMOVAR_UZOR_SVN_PACKAGE'

    input_parameters = (
        parameters.SandboxArcadiaUrlParameter,
        YaPackage.PackagesParameter,
        YaPackage.ResourceTypeParameter,
    )

    def initCtx(self):
        YaPackage.YaPackage.initCtx(self)
        self.ctx[YaPackage.PackageTypeParameter.name] = YaPackage.TARBALL
        self.ctx[YaPackage.PackagesParameter.name] = 'robot/uzor/packages/svn_configs.json'
        self.ctx[YaPackage.ResourceTypeParameter.name] = str(resource_types.SAMOVAR_UZOR_SVN_CONFIGS)
        self.ctx[YaPackage.PublishPackageParameter.name] = False

    def on_release(self, additional_parameters):
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        YaPackage.YaPackage.on_release(self, additional_parameters)


__Task__ = BuildSamovarUzorSvnPackage
